/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.esper.client.soda.StreamSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertIntoClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final boolean isIStream;
    private final String streamName;
    private List<String> columnNames;

    public static InsertIntoClause create(String streamName) {
        return new InsertIntoClause(streamName);
    }

    public static InsertIntoClause create(String streamName, String ... columns) {
        return new InsertIntoClause(streamName, columns);
    }

    public static InsertIntoClause create(String streamName, String[] columns, StreamSelector streamSelector) {
        if (streamSelector == StreamSelector.RSTREAM_ISTREAM_BOTH) {
            throw new IllegalArgumentException("Insert into only allows istream or rstream selection, not both");
        }
        return new InsertIntoClause(streamName, Arrays.asList(columns), streamSelector != StreamSelector.RSTREAM_ONLY);
    }

    public InsertIntoClause(String streamName) {
        this.isIStream = true;
        this.streamName = streamName;
        this.columnNames = new ArrayList<String>();
    }

    public InsertIntoClause(String streamName, String[] columnNames) {
        this.isIStream = true;
        this.streamName = streamName;
        this.columnNames = Arrays.asList(columnNames);
    }

    public InsertIntoClause(String streamName, List<String> columnNames, boolean isIStream) {
        this.isIStream = isIStream;
        this.streamName = streamName;
        this.columnNames = columnNames;
    }

    public boolean isIStream() {
        return this.isIStream;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void add(String columnName) {
        this.columnNames.add(columnName);
    }

    public void toEQL(StringWriter writer) {
        writer.write("insert ");
        if (!this.isIStream) {
            writer.write("rstream ");
        }
        writer.write("into ");
        writer.write(this.streamName);
        if (this.columnNames.size() > 0) {
            writer.write("(");
            String delimiter = "";
            for (String name : this.columnNames) {
                writer.write(delimiter);
                writer.write(name);
                delimiter = ", ";
            }
            writer.write(")");
        }
        writer.write(32);
    }
}

