/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import net.esper.client.soda.Expression;
import net.esper.client.soda.ExpressionBase;

public class InstanceOfExpression
extends ExpressionBase {
    private String[] typeNames;

    public InstanceOfExpression(String[] typeNames) {
        this.typeNames = typeNames;
    }

    public InstanceOfExpression(Expression expressionToCheck, String typeName, String ... moreTypes) {
        this.getChildren().add(expressionToCheck);
        if (moreTypes == null) {
            this.typeNames = new String[]{typeName};
        } else {
            this.typeNames = new String[moreTypes.length + 1];
            this.typeNames[0] = typeName;
            System.arraycopy(moreTypes, 0, this.typeNames, 1, moreTypes.length);
        }
    }

    public void toEQL(StringWriter writer) {
        writer.write("instanceof(");
        this.getChildren().get(0).toEQL(writer);
        writer.write(", ");
        String delimiter = "";
        for (String typeName : this.typeNames) {
            writer.write(delimiter);
            writer.write(typeName);
            delimiter = ", ";
        }
        writer.write(")");
    }

    public String[] getTypeNames() {
        return this.typeNames;
    }

    public void setTypeNames(String[] typeNames) {
        this.typeNames = typeNames;
    }
}

