/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.esper.client.soda.Expression;
import net.esper.client.soda.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocationStream
extends Stream {
    private String className;
    private String methodName;
    private List<Expression> parameterExpressions;

    public static MethodInvocationStream create(String className, String methodName) {
        return new MethodInvocationStream(className, methodName, null);
    }

    public static MethodInvocationStream create(String className, String methodName, String optStreamName) {
        return new MethodInvocationStream(className, methodName, optStreamName);
    }

    public MethodInvocationStream(String className, String methodName, String optStreamName) {
        super(optStreamName);
        this.className = className;
        this.methodName = methodName;
        this.parameterExpressions = new ArrayList<Expression>();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<Expression> getParameterExpressions() {
        return this.parameterExpressions;
    }

    public void setParameterExpressions(List<Expression> parameterExpressions) {
        this.parameterExpressions = parameterExpressions;
    }

    public MethodInvocationStream addParameter(Expression parameterExpression) {
        this.parameterExpressions.add(parameterExpression);
        return this;
    }

    @Override
    public void toEQLStream(StringWriter writer) {
        writer.write("method:");
        writer.write(this.className);
        writer.write(".");
        writer.write(this.methodName);
        writer.write("(");
        for (Expression expr : this.parameterExpressions) {
            expr.toEQL(writer);
        }
        writer.write(")");
    }
}

