/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.esper.client.soda.Expression;
import net.esper.client.soda.OnClause;
import net.esper.collection.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnSetClause
extends OnClause {
    private static final long serialVersionUID = 0L;
    private List<Pair<String, Expression>> assignments = new ArrayList<Pair<String, Expression>>();

    public static OnSetClause create(String variableName, Expression expression) {
        OnSetClause clause = new OnSetClause();
        clause.addAssignment(variableName, expression);
        return clause;
    }

    public OnSetClause addAssignment(String variable, Expression expression) {
        this.assignments.add(new Pair<String, Expression>(variable, expression));
        return this;
    }

    public List<Pair<String, Expression>> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<Pair<String, Expression>> assignments) {
        this.assignments = assignments;
    }

    public void toEQL(StringWriter writer) {
        writer.write(" set ");
        String delimiter = "";
        for (Pair<String, Expression> pair : this.assignments) {
            writer.write(delimiter);
            writer.write(pair.getFirst());
            writer.write(" = ");
            pair.getSecond().toEQL(writer);
            delimiter = ", ";
        }
    }
}

