/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.Serializable;
import java.io.StringWriter;
import net.esper.client.soda.OutputLimitSelector;
import net.esper.client.soda.OutputLimitUnit;

public class OutputLimitClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private OutputLimitSelector selector;
    private Double frequency;
    private String frequencyVariable;
    private OutputLimitUnit unit;

    public static OutputLimitClause create(OutputLimitSelector selector, double frequency, OutputLimitUnit unit) {
        return new OutputLimitClause(selector, frequency, unit);
    }

    public static OutputLimitClause create(OutputLimitSelector selector, String frequencyVariable, OutputLimitUnit unit) {
        return new OutputLimitClause(selector, frequencyVariable, unit);
    }

    public static OutputLimitClause create(double frequency, OutputLimitUnit unit) {
        return new OutputLimitClause(OutputLimitSelector.ALL, frequency, unit);
    }

    public static OutputLimitClause create(String frequencyVariable, OutputLimitUnit unit) {
        return new OutputLimitClause(OutputLimitSelector.ALL, frequencyVariable, unit);
    }

    public OutputLimitClause(OutputLimitSelector selector, Double frequency, OutputLimitUnit unit) {
        this.selector = selector;
        this.frequency = frequency;
        this.unit = unit;
    }

    public OutputLimitClause(OutputLimitSelector selector, String frequencyVariable, OutputLimitUnit unit) {
        this.selector = selector;
        this.frequencyVariable = frequencyVariable;
        this.unit = unit;
    }

    public OutputLimitClause(OutputLimitSelector selector, Double frequency, String frequencyVariable, OutputLimitUnit unit) {
        this.selector = selector;
        this.frequency = frequency;
        this.frequencyVariable = frequencyVariable;
        this.unit = unit;
    }

    public OutputLimitSelector getSelector() {
        return this.selector;
    }

    public void setSelector(OutputLimitSelector selector) {
        this.selector = selector;
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public OutputLimitUnit getUnit() {
        return this.unit;
    }

    public void setUnit(OutputLimitUnit unit) {
        this.unit = unit;
    }

    public String getFrequencyVariable() {
        return this.frequencyVariable;
    }

    public void setFrequencyVariable(String frequencyVariable) {
        this.frequencyVariable = frequencyVariable;
    }

    public void toEQL(StringWriter writer) {
        if (this.selector != OutputLimitSelector.ALL) {
            writer.write(this.selector.getText());
            writer.write(" ");
        }
        writer.write("every ");
        if (this.unit != OutputLimitUnit.EVENTS) {
            if (this.frequencyVariable == null) {
                writer.write(Double.toString(this.frequency));
            } else {
                writer.write(this.frequencyVariable);
            }
        } else if (this.frequencyVariable == null) {
            writer.write(Integer.toString(this.frequency.intValue()));
        } else {
            writer.write(this.frequencyVariable);
        }
        writer.write(32);
        writer.write(this.unit.getText());
    }
}

