/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import java.util.List;
import net.esper.client.soda.Stream;
import net.esper.client.soda.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectedStream
extends Stream {
    private List<View> views;

    public abstract void toEQLProjectedStream(StringWriter var1);

    protected ProjectedStream(List<View> views, String optStreamName) {
        super(optStreamName);
        this.views = views;
    }

    public ProjectedStream addView(String namespace, String name) {
        this.views.add(View.create(namespace, name));
        return this;
    }

    public ProjectedStream addView(String namespace, String name, List<Object> parameters) {
        this.views.add(View.create(namespace, name, parameters));
        return this;
    }

    public ProjectedStream addView(String namespace, String name, Object ... parameters) {
        this.views.add(View.create(namespace, name, parameters));
        return this;
    }

    public ProjectedStream addView(View view) {
        this.views.add(view);
        return this;
    }

    public List<View> getViews() {
        return this.views;
    }

    public void setViews(List<View> views) {
        this.views = views;
    }

    @Override
    public void toEQLStream(StringWriter writer) {
        this.toEQLProjectedStream(writer);
        ProjectedStream.toEQLViews(writer, this.views);
    }

    protected static void toEQLViews(StringWriter writer, List<View> views) {
        if (views != null && views.size() != 0) {
            writer.write(46);
            String delimiter = "";
            for (View view : views) {
                writer.write(delimiter);
                view.toEQL(writer);
                delimiter = ".";
            }
        }
    }
}

