/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.esper.client.soda.Expression;
import net.esper.client.soda.PropertyValueExpression;
import net.esper.client.soda.SelectClauseElement;
import net.esper.client.soda.SelectClauseStreamWildcard;
import net.esper.client.soda.StreamSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private StreamSelector streamSelector;
    private List<SelectClauseElement> selectList;
    private List<SelectClauseStreamWildcard> streamWildcardSelectList;
    private boolean isWildcard;

    public static SelectClause createWildcard() {
        return new SelectClause(StreamSelector.RSTREAM_ISTREAM_BOTH, true);
    }

    public static SelectClause create() {
        return new SelectClause(StreamSelector.RSTREAM_ISTREAM_BOTH, false);
    }

    public static SelectClause create(String ... propertyNames) {
        return new SelectClause(StreamSelector.RSTREAM_ISTREAM_BOTH, propertyNames);
    }

    public static SelectClause createStreamWildcard(String streamAliasName) {
        SelectClause clause = new SelectClause(StreamSelector.RSTREAM_ISTREAM_BOTH, false);
        clause.addStreamWildcard(streamAliasName);
        return clause;
    }

    public static SelectClause createWildcard(StreamSelector streamSelector) {
        return new SelectClause(streamSelector, true);
    }

    public static SelectClause create(StreamSelector streamSelector) {
        return new SelectClause(streamSelector, false);
    }

    public static SelectClause create(StreamSelector streamSelector, String ... propertyNames) {
        return new SelectClause(streamSelector, propertyNames);
    }

    protected SelectClause(StreamSelector streamSelector, boolean isWildcard) {
        this.streamSelector = streamSelector;
        this.selectList = new ArrayList<SelectClauseElement>();
        this.streamWildcardSelectList = new ArrayList<SelectClauseStreamWildcard>();
        this.isWildcard = isWildcard;
    }

    public SelectClause(StreamSelector streamSelector, String ... propertyNames) {
        this(streamSelector, false);
        for (String name : propertyNames) {
            this.selectList.add(new SelectClauseElement(new PropertyValueExpression(name)));
        }
    }

    public SelectClause add(String ... propertyNames) {
        for (String name : propertyNames) {
            this.selectList.add(new SelectClauseElement(new PropertyValueExpression(name)));
        }
        return this;
    }

    public SelectClause addWithAlias(String propertyName, String asName) {
        this.selectList.add(new SelectClauseElement(new PropertyValueExpression(propertyName), asName));
        return this;
    }

    public SelectClause add(Expression expression) {
        this.selectList.add(new SelectClauseElement(expression));
        return this;
    }

    public SelectClause add(Expression expression, String asName) {
        this.selectList.add(new SelectClauseElement(expression, asName));
        return this;
    }

    public StreamSelector getStreamSelector() {
        return this.streamSelector;
    }

    public List<SelectClauseElement> getSelectList() {
        return this.selectList;
    }

    public SelectClause addStreamWildcard(String streamAliasName) {
        this.streamWildcardSelectList.add(new SelectClauseStreamWildcard(streamAliasName, null));
        return this;
    }

    public SelectClause addStreamWildcard(String streamAliasName, String columnAlias) {
        this.streamWildcardSelectList.add(new SelectClauseStreamWildcard(streamAliasName, columnAlias));
        return this;
    }

    public List<SelectClauseStreamWildcard> getStreamWildcardSelectList() {
        return this.streamWildcardSelectList;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public void setStreamSelector(StreamSelector streamSelector) {
        this.streamSelector = streamSelector;
    }

    public void setSelectList(List<SelectClauseElement> selectList) {
        this.selectList = selectList;
    }

    public void setWildcard(boolean wildcard) {
        this.isWildcard = wildcard;
    }

    public void toEQL(StringWriter writer) {
        writer.write("select ");
        if (this.streamSelector == StreamSelector.ISTREAM_ONLY) {
            writer.write("istream ");
        } else if (this.streamSelector == StreamSelector.RSTREAM_ONLY) {
            writer.write("rstream ");
        }
        String delimiter = "";
        if (this.isWildcard) {
            writer.write("*");
            delimiter = ", ";
        }
        for (SelectClauseStreamWildcard selectClauseStreamWildcard : this.streamWildcardSelectList) {
            writer.write(delimiter);
            selectClauseStreamWildcard.toEQL(writer);
            delimiter = ", ";
        }
        for (SelectClauseElement selectClauseElement : this.selectList) {
            writer.write(delimiter);
            selectClauseElement.toEQL(writer);
            delimiter = ", ";
        }
        writer.write(32);
    }
}

