/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import net.esper.client.soda.ConstantExpression;
import net.esper.client.soda.Expression;
import net.esper.client.soda.ExpressionBase;

public class StaticMethodExpression
extends ExpressionBase {
    private String className;
    private String method;

    public StaticMethodExpression(String className, String method, Object[] parameters) {
        this.className = className;
        this.method = method;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof Expression) {
                this.getChildren().add((Expression)parameters[i]);
                continue;
            }
            this.getChildren().add(new ConstantExpression(parameters[i]));
        }
    }

    public StaticMethodExpression(String className, String method) {
        this.className = className;
        this.method = method;
    }

    public void toEQL(StringWriter writer) {
        writer.write(this.className);
        writer.write(46);
        writer.write(this.method);
        writer.write(40);
        String delimiter = "";
        for (Expression child : this.getChildren()) {
            writer.write(delimiter);
            child.toEQL(writer);
            delimiter = ", ";
        }
        writer.write(41);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

