/*
 * Decompiled with CFR 0.152.
 */
package net.esper.collection;

import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBackedCollection<T>
implements Collection<T> {
    private int lastIndex;
    private int currentIndex;
    private Object[] handles;

    public ArrayBackedCollection(int currentSize) {
        this.lastIndex = currentSize - 1;
        this.currentIndex = 0;
        this.handles = new Object[currentSize];
    }

    @Override
    public boolean add(T object) {
        if (this.currentIndex <= this.lastIndex) {
            this.handles[this.currentIndex++] = object;
            return true;
        }
        int newSize = this.lastIndex * 2 + 2;
        Object[] newHandles = new Object[newSize];
        System.arraycopy(this.handles, 0, newHandles, 0, this.handles.length);
        this.handles = newHandles;
        this.lastIndex = newSize - 1;
        this.handles[this.currentIndex++] = object;
        return true;
    }

    @Override
    public void clear() {
        this.currentIndex = 0;
    }

    @Override
    public int size() {
        return this.currentIndex;
    }

    public Object[] getArray() {
        return this.handles;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }
}

