/*
 * Decompiled with CFR 0.152.
 */
package net.esper.collection;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IterablesListIterator
implements Iterator<EventBean> {
    private final Iterator<Iterable<EventBean>> listIterator;
    private Iterator<EventBean> currentIterator;

    public IterablesListIterator(List<Iterable<EventBean>> iterables) {
        this.listIterator = iterables.iterator();
        this.nextIterable();
    }

    @Override
    public EventBean next() {
        if (this.currentIterator == null) {
            throw new NoSuchElementException();
        }
        if (this.currentIterator.hasNext()) {
            return this.currentIterator.next();
        }
        this.nextIterable();
        if (this.currentIterator == null) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null) {
            return false;
        }
        if (this.currentIterator.hasNext()) {
            return true;
        }
        this.nextIterable();
        return this.currentIterator != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void nextIterable() {
        while (this.listIterator.hasNext()) {
            Iterable<EventBean> iterable = this.listIterator.next();
            this.currentIterator = iterable.iterator();
            if (!this.currentIterator.hasNext()) continue;
            return;
        }
        this.currentIterator = null;
    }
}

