/*
 * Decompiled with CFR 0.152.
 */
package net.esper.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.esper.collection.Pair;
import net.esper.collection.TimeWindowIterator;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeWindow
implements Iterable {
    private final LinkedList<Pair<Long, LinkedList<EventBean>>> window = new LinkedList();
    private Long oldestTimestamp = null;
    private Map<EventBean, LinkedList<EventBean>> reverseIndex;

    public TimeWindow(boolean isSupportRemoveStream) {
        if (isSupportRemoveStream) {
            this.reverseIndex = new HashMap<EventBean, LinkedList<EventBean>>();
        }
    }

    public final void add(long timestamp, EventBean bean) {
        if (this.oldestTimestamp == null) {
            this.oldestTimestamp = timestamp;
        }
        if (this.window.isEmpty()) {
            LinkedList<EventBean> listOfBeans = new LinkedList<EventBean>();
            listOfBeans.add(bean);
            Pair pair = new Pair(timestamp, listOfBeans);
            this.window.add(pair);
            if (this.reverseIndex != null) {
                this.reverseIndex.put(bean, listOfBeans);
            }
            return;
        }
        Pair<Long, LinkedList<EventBean>> lastPair = this.window.getLast();
        if (lastPair.getFirst() == timestamp) {
            lastPair.getSecond().add(bean);
            if (this.reverseIndex != null) {
                this.reverseIndex.put(bean, lastPair.getSecond());
            }
            return;
        }
        LinkedList<EventBean> listOfBeans = new LinkedList<EventBean>();
        listOfBeans.add(bean);
        Pair pair = new Pair(timestamp, listOfBeans);
        if (this.reverseIndex != null) {
            this.reverseIndex.put(bean, listOfBeans);
        }
        this.window.add(pair);
    }

    public final void remove(EventBean event) {
        if (this.reverseIndex == null) {
            throw new UnsupportedOperationException("Time window does not accept event removal");
        }
        List list = this.reverseIndex.get(event);
        if (list != null) {
            list.remove(event);
        }
        this.reverseIndex.remove(event);
    }

    public final List<EventBean> expireEvents(long expireBefore) {
        if (this.window.isEmpty()) {
            return null;
        }
        Pair<Long, LinkedList<EventBean>> pair = this.window.getFirst();
        if (pair.getFirst() >= expireBefore) {
            return null;
        }
        LinkedList<EventBean> resultBeans = new LinkedList<EventBean>();
        do {
            resultBeans.addAll((Collection)pair.getSecond());
            this.window.removeFirst();
        } while (!this.window.isEmpty() && (pair = this.window.getFirst()).getFirst() < expireBefore);
        this.oldestTimestamp = this.window.isEmpty() ? null : pair.getFirst();
        if (this.reverseIndex != null) {
            for (EventBean expired : resultBeans) {
                this.reverseIndex.remove(expired);
            }
        }
        return resultBeans;
    }

    public final Iterator<EventBean> iterator() {
        return new TimeWindowIterator(this.window);
    }

    public final Long getOldestTimestamp() {
        return this.oldestTimestamp;
    }

    public final boolean isEmpty() {
        return this.window.isEmpty();
    }

    protected Map<EventBean, LinkedList<EventBean>> getReverseIndex() {
        return this.reverseIndex;
    }
}

