/*
 * Decompiled with CFR 0.152.
 */
package net.esper.collection;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.esper.collection.Pair;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeWindowIterator
implements Iterator<EventBean> {
    private final Iterator<Pair<Long, LinkedList<EventBean>>> keyIterator;
    private Iterator<EventBean> currentListIterator;

    public TimeWindowIterator(LinkedList<Pair<Long, LinkedList<EventBean>>> window) {
        this.keyIterator = window.iterator();
        if (this.keyIterator.hasNext()) {
            Pair<Long, LinkedList<EventBean>> pair = this.keyIterator.next();
            while (pair.getSecond().isEmpty() && this.keyIterator.hasNext()) {
                pair = this.keyIterator.next();
            }
            this.currentListIterator = pair.getSecond().iterator();
        }
    }

    @Override
    public final EventBean next() {
        if (this.currentListIterator == null) {
            throw new NoSuchElementException();
        }
        EventBean eventBean = this.currentListIterator.next();
        if (!this.currentListIterator.hasNext()) {
            this.currentListIterator = null;
            if (this.keyIterator.hasNext()) {
                Pair<Long, LinkedList<EventBean>> pair = this.keyIterator.next();
                while (pair.getSecond().isEmpty() && this.keyIterator.hasNext()) {
                    pair = this.keyIterator.next();
                }
                this.currentListIterator = pair.getSecond().iterator();
            }
        }
        return eventBean;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasNext() {
        if (this.currentListIterator == null) {
            return false;
        }
        if (this.currentListIterator.hasNext()) {
            return true;
        }
        this.currentListIterator = null;
        return this.keyIterator.hasNext();
    }
}

