/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.esper.client.ConfigurationEventTypeXMLDOM;
import net.esper.client.ConfigurationException;
import net.esper.client.ConfigurationOperations;
import net.esper.eql.core.EngineImportException;
import net.esper.eql.core.EngineImportService;
import net.esper.eql.variable.VariableExistsException;
import net.esper.eql.variable.VariableService;
import net.esper.eql.variable.VariableTypeException;
import net.esper.event.EventAdapterException;
import net.esper.event.EventAdapterService;
import net.esper.util.JavaClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationOperationsImpl
implements ConfigurationOperations {
    private final EventAdapterService eventAdapterService;
    private final EngineImportService engineImportService;
    private final VariableService variableService;

    public ConfigurationOperationsImpl(EventAdapterService eventAdapterService, EngineImportService engineImportService, VariableService variableService) {
        this.eventAdapterService = eventAdapterService;
        this.engineImportService = engineImportService;
        this.variableService = variableService;
    }

    @Override
    public void addEventTypeAutoAlias(String javaPackageName) {
        this.eventAdapterService.addAutoAliasPackage(javaPackageName);
    }

    @Override
    public void addPlugInAggregationFunction(String functionName, String aggregationClassName) {
        try {
            this.engineImportService.addAggregation(functionName, aggregationClassName);
        }
        catch (EngineImportException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void addImport(String importName) {
        try {
            this.engineImportService.addImport(importName);
        }
        catch (EngineImportException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, String javaEventClassName) {
        try {
            this.eventAdapterService.addBeanType(eventTypeAlias, javaEventClassName, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, Class javaEventClass) {
        try {
            this.eventAdapterService.addBeanType(eventTypeAlias, javaEventClass);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventTypeAliasSimpleName(Class javaEventClass) {
        try {
            this.eventAdapterService.addBeanType(javaEventClass.getSimpleName(), javaEventClass);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, Properties typeMap) {
        Map<String, Class> types = ConfigurationOperationsImpl.createPropertyTypes(typeMap);
        try {
            this.eventAdapterService.addMapType(eventTypeAlias, types);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, Map<String, Class> typeMap) {
        try {
            this.eventAdapterService.addMapType(eventTypeAlias, typeMap);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, ConfigurationEventTypeXMLDOM xmlDOMEventTypeDesc) {
        try {
            this.eventAdapterService.addXMLDOMType(eventTypeAlias, xmlDOMEventTypeDesc);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    private static Map<String, Class> createPropertyTypes(Properties properties) {
        HashMap<String, Class> propertyTypes = new HashMap<String, Class>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Class<?> clazz;
            String className = (String)entry.getValue();
            if ("string".equals(className)) {
                className = String.class.getName();
            }
            String boxedClassName = JavaClassHelper.getBoxedClassName(className);
            try {
                clazz = Class.forName(boxedClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Unable to load class '" + boxedClassName + "', class not found", ex);
            }
            propertyTypes.put((String)entry.getKey(), clazz);
        }
        return propertyTypes;
    }

    @Override
    public void addVariable(String variableName, Class type, Object initializationValue) throws ConfigurationException {
        try {
            this.variableService.createNewVariable(variableName, type, initializationValue, null);
        }
        catch (VariableExistsException e) {
            throw new ConfigurationException("Error creating variable: " + e.getMessage(), e);
        }
        catch (VariableTypeException e) {
            throw new ConfigurationException("Error creating variable: " + e.getMessage(), e);
        }
    }
}

