/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import net.esper.client.ConfigurationOperations;
import net.esper.client.EPAdministrator;
import net.esper.client.EPException;
import net.esper.client.EPPreparedStatement;
import net.esper.client.EPPreparedStatementImpl;
import net.esper.client.EPStatement;
import net.esper.client.EPStatementException;
import net.esper.client.soda.EPStatementObjectModel;
import net.esper.core.EPServicesContext;
import net.esper.eql.generated.EQLBaseWalker;
import net.esper.eql.generated.EQLStatementParser;
import net.esper.eql.parse.ASTWalkException;
import net.esper.eql.parse.EQLTreeWalker;
import net.esper.eql.parse.ParseHelper;
import net.esper.eql.parse.ParseRuleSelector;
import net.esper.eql.parse.WalkRuleSelector;
import net.esper.eql.spec.PatternStreamSpecRaw;
import net.esper.eql.spec.StatementSpecMapper;
import net.esper.eql.spec.StatementSpecRaw;
import net.esper.eql.spec.StatementSpecUnMapResult;
import net.esper.util.DebugFacility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPAdministratorImpl
implements EPAdministrator {
    private static ParseRuleSelector patternParseRule = new ParseRuleSelector(){

        public void invokeParseRule(EQLStatementParser parser2) throws TokenStreamException, RecognitionException {
            parser2.startPatternExpressionRule();
        }
    };
    private static ParseRuleSelector eqlParseRule;
    private static WalkRuleSelector patternWalkRule;
    private static WalkRuleSelector eqlWalkRule;
    private EPServicesContext services;
    private ConfigurationOperations configurationOperations;
    private static Log log;

    public EPAdministratorImpl(EPServicesContext services, ConfigurationOperations configurationOperations) {
        this.services = services;
        this.configurationOperations = configurationOperations;
    }

    public EPStatement createPattern(String onExpression) throws EPException {
        return this.createPatternStmt(onExpression, null);
    }

    public EPStatement createEQL(String eqlStatement) throws EPException {
        return this.createEQLStmt(eqlStatement, null);
    }

    public EPStatement createPattern(String expression, String statementName) throws EPException {
        return this.createPatternStmt(expression, statementName);
    }

    public EPStatement createEQL(String eqlStatement, String statementName) throws EPException {
        return this.createEQLStmt(eqlStatement, statementName);
    }

    private EPStatement createPatternStmt(String expression, String statementName) throws EPException {
        StatementSpecRaw rawPattern = this.compilePattern(expression);
        return this.services.getStatementLifecycleSvc().createAndStart(rawPattern, expression, true, statementName);
    }

    private EPStatement createEQLStmt(String eqlStatement, String statementName) throws EPException {
        StatementSpecRaw statementSpec = this.compileEQL(eqlStatement, statementName);
        EPStatement statement = this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eqlStatement, false, statementName);
        log.debug(".createEQLStmt Statement created and started");
        return statement;
    }

    public EPStatement create(EPStatementObjectModel sodaStatement) throws EPException {
        return this.create(sodaStatement, null);
    }

    public EPStatement create(EPStatementObjectModel sodaStatement, String statementName) throws EPException {
        StatementSpecRaw statementSpec = StatementSpecMapper.map(sodaStatement, this.services.getEngineImportService(), this.services.getVariableService());
        String eqlStatement = sodaStatement.toEQL();
        EPStatement statement = this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eqlStatement, false, statementName);
        log.debug(".createEQLStmt Statement created and started");
        return statement;
    }

    public EPPreparedStatement prepareEQL(String eqlExpression) throws EPException {
        StatementSpecRaw statementSpec = this.compileEQL(eqlExpression, null);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(statementSpec);
        return new EPPreparedStatementImpl(unmapped.getObjectModel(), unmapped.getIndexedParams());
    }

    public EPPreparedStatement preparePattern(String patternExpression) throws EPException {
        StatementSpecRaw rawPattern = this.compilePattern(patternExpression);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(rawPattern);
        return new EPPreparedStatementImpl(unmapped.getObjectModel(), unmapped.getIndexedParams());
    }

    public EPStatement create(EPPreparedStatement prepared, String statementName) throws EPException {
        EPPreparedStatementImpl impl = (EPPreparedStatementImpl)prepared;
        StatementSpecRaw statementSpec = StatementSpecMapper.map(impl.getModel(), this.services.getEngineImportService(), this.services.getVariableService());
        String eqlStatement = impl.getModel().toEQL();
        return this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eqlStatement, false, statementName);
    }

    public EPStatement create(EPPreparedStatement prepared) throws EPException {
        return this.create(prepared, null);
    }

    public EPStatementObjectModel compileEQL(String eqlStatement) throws EPException {
        StatementSpecRaw statementSpec = this.compileEQL(eqlStatement, null);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(statementSpec);
        if (unmapped.getIndexedParams().size() != 0) {
            throw new EPException("Invalid use of substitution parameters marked by '?' in statement, use the prepare method to prepare statements with substitution parameters");
        }
        return unmapped.getObjectModel();
    }

    public EPStatement getStatement(String name) {
        return this.services.getStatementLifecycleSvc().getStatementByName(name);
    }

    public String[] getStatementNames() {
        return this.services.getStatementLifecycleSvc().getStatementNames();
    }

    public void startAllStatements() throws EPException {
        this.services.getStatementLifecycleSvc().startAllStatements();
    }

    public void stopAllStatements() throws EPException {
        this.services.getStatementLifecycleSvc().stopAllStatements();
    }

    public void destroyAllStatements() throws EPException {
        this.services.getStatementLifecycleSvc().destroyAllStatements();
    }

    public ConfigurationOperations getConfiguration() {
        return this.configurationOperations;
    }

    public void destroy() {
        this.services = null;
        this.configurationOperations = null;
    }

    private StatementSpecRaw compileEQL(String eqlStatement, String statementName) {
        if (log.isDebugEnabled()) {
            log.debug(".createEQLStmt statementName=" + statementName + " eqlStatement=" + eqlStatement);
        }
        AST ast = ParseHelper.parse(eqlStatement, eqlParseRule);
        EQLTreeWalker walker = new EQLTreeWalker(this.services.getEngineImportService(), this.services.getVariableService());
        try {
            ParseHelper.walk(ast, walker, eqlWalkRule, eqlStatement);
        }
        catch (ASTWalkException ex) {
            log.error(".createEQL Error validating expression", ex);
            throw new EPStatementException(ex.getMessage(), eqlStatement);
        }
        catch (RuntimeException ex) {
            log.error(".createEQL Error validating expression", ex);
            throw new EPStatementException(ex.getMessage(), eqlStatement);
        }
        if (log.isDebugEnabled()) {
            DebugFacility.dumpAST(walker.getAST());
        }
        return walker.getStatementSpec();
    }

    private StatementSpecRaw compilePattern(String expression) {
        AST ast = ParseHelper.parse(expression, patternParseRule);
        EQLTreeWalker walker = new EQLTreeWalker(this.services.getEngineImportService(), this.services.getVariableService());
        try {
            ParseHelper.walk(ast, walker, patternWalkRule, expression);
        }
        catch (ASTWalkException ex) {
            log.debug(".createPattern Error validating expression", ex);
            throw new EPStatementException(ex.getMessage(), expression);
        }
        catch (RuntimeException ex) {
            log.debug(".createPattern Error validating expression", ex);
            throw new EPStatementException(ex.getMessage(), expression);
        }
        if (log.isDebugEnabled()) {
            DebugFacility.dumpAST(walker.getAST());
        }
        if (walker.getStatementSpec().getStreamSpecs().size() > 1) {
            throw new IllegalStateException("Unexpected multiple stream specifications encountered");
        }
        PatternStreamSpecRaw patternStreamSpec = (PatternStreamSpecRaw)walker.getStatementSpec().getStreamSpecs().get(0);
        StatementSpecRaw statementSpec = new StatementSpecRaw();
        statementSpec.getStreamSpecs().add(patternStreamSpec);
        statementSpec.getSelectClauseSpec().setIsUsingWildcard(true);
        return statementSpec;
    }

    static {
        patternWalkRule = new WalkRuleSelector(){

            public void invokeWalkRule(EQLBaseWalker walker, AST ast) throws RecognitionException {
                walker.startPatternExpressionRule(ast);
            }
        };
        eqlParseRule = new ParseRuleSelector(){

            public void invokeParseRule(EQLStatementParser parser2) throws TokenStreamException, RecognitionException {
                parser2.startEQLExpressionRule();
            }
        };
        eqlWalkRule = new WalkRuleSelector(){

            public void invokeWalkRule(EQLBaseWalker walker, AST ast) throws RecognitionException {
                walker.startEQLExpressionRule(ast);
            }
        };
        log = LogFactory.getLog(EPAdministratorImpl.class);
    }
}

