/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.esper.client.EPException;
import net.esper.client.EPRuntime;
import net.esper.client.EmittedListener;
import net.esper.client.UnmatchedListener;
import net.esper.client.time.CurrentTimeEvent;
import net.esper.client.time.TimerControlEvent;
import net.esper.client.time.TimerEvent;
import net.esper.collection.ArrayBackedCollection;
import net.esper.collection.ThreadWorkQueue;
import net.esper.core.EPServicesContext;
import net.esper.core.EPStatementHandle;
import net.esper.core.EPStatementHandleCallback;
import net.esper.core.InsertIntoLatchFactory;
import net.esper.core.InsertIntoLatchSpin;
import net.esper.core.InsertIntoLatchWait;
import net.esper.core.InternalEventRouter;
import net.esper.event.EventBean;
import net.esper.filter.FilterHandle;
import net.esper.filter.FilterHandleCallback;
import net.esper.schedule.ScheduleHandle;
import net.esper.schedule.ScheduleHandleCallback;
import net.esper.timer.TimerCallback;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.util.ManagedLock;
import net.esper.util.ThreadLogUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPRuntimeImpl
implements EPRuntime,
TimerCallback,
InternalEventRouter {
    private EPServicesContext services;
    private boolean isLatchStatementInsertStream;
    private volatile UnmatchedListener unmatchedListener;
    private ThreadLocal<ArrayBackedCollection<FilterHandle>> matchesArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<FilterHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<FilterHandle> initialValue() {
            return new ArrayBackedCollection<FilterHandle>(100);
        }
    };
    private ThreadLocal<HashMap<EPStatementHandle, Object>> matchesPerStmtThreadLocal = new ThreadLocal<HashMap<EPStatementHandle, Object>>(){

        @Override
        protected synchronized HashMap<EPStatementHandle, Object> initialValue() {
            return new HashMap<EPStatementHandle, Object>(10000);
        }
    };
    private ThreadLocal<ArrayBackedCollection<ScheduleHandle>> scheduleArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<ScheduleHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<ScheduleHandle> initialValue() {
            return new ArrayBackedCollection<ScheduleHandle>(100);
        }
    };
    private ThreadLocal<HashMap<EPStatementHandle, Object>> schedulePerStmtThreadLocal = new ThreadLocal<HashMap<EPStatementHandle, Object>>(){

        @Override
        protected synchronized HashMap<EPStatementHandle, Object> initialValue() {
            return new HashMap<EPStatementHandle, Object>(10000);
        }
    };
    private static final Log log = LogFactory.getLog(EPRuntimeImpl.class);

    public EPRuntimeImpl(EPServicesContext services) {
        this.services = services;
        this.isLatchStatementInsertStream = this.services.getEngineSettingsService().getEngineSettings().getThreading().isInsertIntoDispatchPreserveOrder();
    }

    @Override
    public void timerCallback() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".timerCallback Evaluating scheduled callbacks");
        }
        long msec = System.currentTimeMillis();
        CurrentTimeEvent currentTimeEvent = new CurrentTimeEvent(msec);
        this.sendEvent(currentTimeEvent);
    }

    @Override
    public void sendEvent(Object event) throws EPException {
        if (event == null) {
            log.fatal(".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendEvent Processing event " + event);
        }
        this.processEvent(event);
    }

    @Override
    public void sendEvent(Node document) throws EPException {
        if (document == null) {
            log.fatal(".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendEvent Processing DOM node event " + document);
        }
        EventBean eventBean = this.services.getEventAdapterService().adapterForDOM(document);
        this.processEvent(eventBean);
    }

    @Override
    public void sendEvent(Map map, String eventTypeAlias) throws EPException {
        if (map == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendMap Processing event " + map);
        }
        EventBean eventBean = this.services.getEventAdapterService().adapterForMap(map, eventTypeAlias);
        this.processEvent(eventBean);
    }

    @Override
    public int getNumEventsReceived() {
        return this.services.getFilterService().getNumEventsEvaluated();
    }

    @Override
    public int getNumEventsEmitted() {
        return this.services.getEmitService().getNumEventsEmitted();
    }

    @Override
    public void route(Object event) {
        ThreadWorkQueue.add(event);
    }

    @Override
    public void route(EventBean[] events, EPStatementHandle epStatementHandle) {
        if (this.isLatchStatementInsertStream) {
            InsertIntoLatchFactory insertIntoLatchFactory = epStatementHandle.getInsertIntoLatchFactory();
            for (EventBean event : events) {
                Object latch = insertIntoLatchFactory.newLatch(event);
                ThreadWorkQueue.add(latch);
            }
        } else {
            for (EventBean event : events) {
                ThreadWorkQueue.add(event);
            }
        }
    }

    @Override
    public void emit(Object object) {
        this.services.getEmitService().emitEvent(object, null);
    }

    @Override
    public void emit(Object object, String channel) {
        this.services.getEmitService().emitEvent(object, channel);
    }

    @Override
    public void addEmittedListener(EmittedListener listener, String channel) {
        this.services.getEmitService().addListener(listener, channel);
    }

    @Override
    public void clearEmittedListeners() {
        this.services.getEmitService().clearListeners();
    }

    private void processEvent(Object event) {
        if (event instanceof TimerEvent) {
            this.processTimeEvent((TimerEvent)event);
            return;
        }
        EventBean eventBean = event instanceof EventBean ? (EventBean)event : this.services.getEventAdapterService().adapterForBean(event);
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            throw new EPException(ex);
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
        this.processThreadWorkQueue();
    }

    private void processTimeEvent(TimerEvent event) {
        if (event instanceof TimerControlEvent) {
            TimerControlEvent timerControlEvent = (TimerControlEvent)event;
            if (timerControlEvent.getClockType() == TimerControlEvent.ClockType.CLOCK_INTERNAL) {
                this.services.getTimerService().startInternalClock();
            } else {
                this.services.getTimerService().stopInternalClock(true);
            }
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".processTimeEvent Setting time and evaluating schedules");
        }
        CurrentTimeEvent current = (CurrentTimeEvent)event;
        long currentTime = current.getTimeInMillis();
        this.services.getSchedulingService().setTime(currentTime);
        this.processSchedule();
        this.dispatch();
        this.processThreadWorkQueue();
    }

    private void processSchedule() {
        ArrayBackedCollection<ScheduleHandle> handles = this.scheduleArrayThreadLocal.get();
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.services.getSchedulingService().evaluate(handles);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processScheduleHandles(handles);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
    }

    private void processScheduleHandles(ArrayBackedCollection<ScheduleHandle> handles) {
        EPStatementHandle handle;
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.trace("Found schedules for", handles.size());
        }
        if (handles.size() == 0) {
            return;
        }
        if (handles.size() == 1) {
            Object[] handleArray = handles.getArray();
            EPStatementHandleCallback handle2 = (EPStatementHandleCallback)handleArray[0];
            ManagedLock statementLock = handle2.getEpStatementHandle().getStatementLock();
            statementLock.acquireLock(this.services.getStatementLockFactory());
            try {
                if (handle2.getEpStatementHandle().isHasVariables()) {
                    this.services.getVariableService().setLocalVersion();
                }
                handle2.getScheduleCallback().scheduledTrigger(this.services.getExtensionServicesContext());
                handle2.getEpStatementHandle().internalDispatch();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                handle2.getEpStatementHandle().getStatementLock().releaseLock(this.services.getStatementLockFactory());
            }
            handles.clear();
            return;
        }
        Object[] matchArray = handles.getArray();
        int entryCount = handles.size();
        HashMap<EPStatementHandle, Object> stmtCallbacks = this.schedulePerStmtThreadLocal.get();
        stmtCallbacks.clear();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getEpStatementHandle();
            ScheduleHandleCallback callback = handleCallback.getScheduleCallback();
            Object entry = stmtCallbacks.get(handle);
            if (entry == null) {
                stmtCallbacks.put(handle, callback);
                continue;
            }
            if (entry instanceof ScheduleHandleCallback) {
                ScheduleHandleCallback existingCallback = (ScheduleHandleCallback)entry;
                LinkedList<ScheduleHandleCallback> entries = new LinkedList<ScheduleHandleCallback>();
                entries.add(existingCallback);
                entries.add(callback);
                stmtCallbacks.put(handle, entries);
                continue;
            }
            LinkedList entries = (LinkedList)entry;
            entries.add(callback);
        }
        handles.clear();
        for (Map.Entry<EPStatementHandle, Object> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            Object callbackObject = entry.getValue();
            handle.getStatementLock().acquireLock(this.services.getStatementLockFactory());
            try {
                if (handle.isHasVariables()) {
                    this.services.getVariableService().setLocalVersion();
                }
                if (callbackObject instanceof LinkedList) {
                    LinkedList callbackList = (LinkedList)callbackObject;
                    for (ScheduleHandleCallback callback : callbackList) {
                        callback.scheduledTrigger(this.services.getExtensionServicesContext());
                    }
                } else {
                    ScheduleHandleCallback callback = (ScheduleHandleCallback)callbackObject;
                    callback.scheduledTrigger(this.services.getExtensionServicesContext());
                }
                handle.internalDispatch();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                handle.getStatementLock().releaseLock(this.services.getStatementLockFactory());
            }
        }
    }

    private void processThreadWorkQueue() {
        Object item;
        while ((item = ThreadWorkQueue.next()) != null) {
            if (item instanceof InsertIntoLatchSpin) {
                this.processThreadWorkQueueLatchedSpin((InsertIntoLatchSpin)item);
                continue;
            }
            if (item instanceof InsertIntoLatchWait) {
                this.processThreadWorkQueueLatchedWait((InsertIntoLatchWait)item);
                continue;
            }
            this.processThreadWorkQueueUnlatched(item);
        }
        boolean haveDispatched = this.services.getNamedWindowService().dispatch();
        if (haveDispatched) {
            this.dispatch();
        }
        if (!ThreadWorkQueue.isEmpty()) {
            this.processThreadWorkQueue();
        }
    }

    private void processThreadWorkQueueLatchedWait(InsertIntoLatchWait insertIntoLatch) {
        Object item = insertIntoLatch.await();
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.services.getEventAdapterService().adapterForBean(item);
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueLatchedSpin(InsertIntoLatchSpin insertIntoLatch) {
        Object item = insertIntoLatch.await();
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.services.getEventAdapterService().adapterForBean(item);
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueUnlatched(Object item) {
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.services.getEventAdapterService().adapterForBean(item);
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processMatches(EventBean event) {
        EPStatementHandle handle;
        ArrayBackedCollection<FilterHandle> matches = this.matchesArrayThreadLocal.get();
        this.services.getFilterService().evaluate(event, matches);
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.trace("Found matches for underlying ", matches.size(), event.getUnderlying());
        }
        if (matches.size() == 0) {
            if (this.unmatchedListener != null) {
                this.unmatchedListener.update(event);
            }
            return;
        }
        HashMap<EPStatementHandle, Object> stmtCallbacks = this.matchesPerStmtThreadLocal.get();
        Object[] matchArray = matches.getArray();
        int entryCount = matches.size();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getEpStatementHandle();
            if (handle.isCanSelfJoin()) {
                ArrayList<FilterHandleCallback> callbacks = (ArrayList<FilterHandleCallback>)stmtCallbacks.get(handle);
                if (callbacks == null) {
                    callbacks = new ArrayList<FilterHandleCallback>();
                    stmtCallbacks.put(handle, callbacks);
                }
                callbacks.add(handleCallback.getFilterCallback());
                continue;
            }
            handle.getStatementLock().acquireLock(this.services.getStatementLockFactory());
            try {
                if (handle.isHasVariables()) {
                    this.services.getVariableService().setLocalVersion();
                }
                handleCallback.getFilterCallback().matchFound(event);
                handle.internalDispatch();
                continue;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                handleCallback.getEpStatementHandle().getStatementLock().releaseLock(this.services.getStatementLockFactory());
            }
        }
        matches.clear();
        if (stmtCallbacks.isEmpty()) {
            return;
        }
        for (Map.Entry<EPStatementHandle, Object> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            handle.getStatementLock().acquireLock(this.services.getStatementLockFactory());
            try {
                if (handle.isHasVariables()) {
                    this.services.getVariableService().setLocalVersion();
                }
                List callbackList = (List)entry.getValue();
                for (FilterHandleCallback callback : callbackList) {
                    callback.matchFound(event);
                }
                handle.internalDispatch();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                handle.getStatementLock().releaseLock(this.services.getStatementLockFactory());
            }
        }
        stmtCallbacks.clear();
    }

    private void dispatch() {
        try {
            this.services.getDispatchService().dispatch();
        }
        catch (RuntimeException ex) {
            throw new EPException(ex);
        }
    }

    public void destroy() {
        this.services = null;
        this.matchesArrayThreadLocal.remove();
        this.matchesPerStmtThreadLocal.remove();
        this.scheduleArrayThreadLocal.remove();
        this.schedulePerStmtThreadLocal.remove();
        this.matchesArrayThreadLocal = null;
        this.matchesPerStmtThreadLocal = null;
        this.scheduleArrayThreadLocal = null;
        this.schedulePerStmtThreadLocal = null;
    }

    @Override
    public void setUnmatchedListener(UnmatchedListener listener) {
        this.unmatchedListener = listener;
    }
}

