/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import java.io.IOException;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import net.esper.adapter.AdapterLoader;
import net.esper.client.Configuration;
import net.esper.client.ConfigurationAdapterLoader;
import net.esper.client.ConfigurationException;
import net.esper.client.ConfigurationInformation;
import net.esper.client.EPAdministrator;
import net.esper.client.EPException;
import net.esper.client.EPRuntime;
import net.esper.core.ConfigurationOperationsImpl;
import net.esper.core.EPAdministratorImpl;
import net.esper.core.EPRuntimeImpl;
import net.esper.core.EPServiceProviderSPI;
import net.esper.core.EPServicesContext;
import net.esper.core.EPServicesContextFactory;
import net.esper.core.EPServicesContextFactoryDefault;
import net.esper.core.ExtensionServicesContext;
import net.esper.event.EventAdapterService;
import net.esper.filter.FilterService;
import net.esper.schedule.SchedulingService;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.util.SerializableObjectCopier;

public class EPServiceProviderImpl
implements EPServiceProviderSPI {
    private volatile EPServiceEngine engine;
    private ConfigurationInformation configSnapshot;
    private String engineURI;

    public EPServiceProviderImpl(Configuration configuration, String engineURI) throws ConfigurationException {
        this.engineURI = engineURI;
        this.configSnapshot = this.takeSnapshot(configuration);
        this.initialize();
    }

    public void setConfiguration(Configuration configuration) {
        this.configSnapshot = this.takeSnapshot(configuration);
    }

    public String getURI() {
        return this.engineURI;
    }

    public EPRuntime getEPRuntime() {
        return this.engine.getRuntime();
    }

    public EPAdministrator getEPAdministrator() {
        return this.engine.getAdmin();
    }

    public EventAdapterService getEventAdapterService() {
        return this.engine.getServices().getEventAdapterService();
    }

    public SchedulingService getSchedulingService() {
        return this.engine.getServices().getSchedulingService();
    }

    public FilterService getFilterService() {
        return this.engine.getServices().getFilterService();
    }

    public ExtensionServicesContext getExtensionServicesContext() {
        return this.engine.getServices().getExtensionServicesContext();
    }

    public Context getContext() {
        return this.engine.getServices().getEngineEnvContext();
    }

    public void destroy() {
        if (this.engine != null) {
            this.engine.getServices().getTimerService().stopInternalClock(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.engine.getRuntime().destroy();
            this.engine.getAdmin().destroy();
            this.engine.getServices().destroy();
            this.engine.getServices().initialize();
        }
        this.engine = null;
    }

    public boolean isDestroyed() {
        return this.engine == null;
    }

    public void initialize() {
        EPServicesContextFactory epServicesContextFactory;
        String epServicesContextFactoryClassName;
        ExecutionPathDebugLog.setDebugEnabled(this.configSnapshot.getEngineDefaults().getLogging().isEnableExecutionDebug());
        if (this.engine != null) {
            this.engine.getServices().getTimerService().stopInternalClock(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.engine.getServices().destroy();
        }
        if ((epServicesContextFactoryClassName = this.configSnapshot.getEPServicesContextFactoryClassName()) == null) {
            epServicesContextFactoryClassName = System.getProperty("ESPER_EPSERVICE_CONTEXT_FACTORY_CLASS");
        }
        if (epServicesContextFactoryClassName == null) {
            epServicesContextFactory = new EPServicesContextFactoryDefault();
        } else {
            Object obj;
            Class<?> clazz;
            try {
                clazz = Class.forName(epServicesContextFactoryClassName);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class '" + epServicesContextFactoryClassName + "' cannot be loaded");
            }
            try {
                obj = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new ConfigurationException("Class '" + clazz + "' cannot be instantiated");
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Illegal access instantiating class '" + clazz);
            }
            epServicesContextFactory = (EPServicesContextFactory)obj;
        }
        EPServicesContext services = epServicesContextFactory.createServicesContext(this, this.configSnapshot);
        EPRuntimeImpl runtime = new EPRuntimeImpl(services);
        services.setInternalEventRouter(runtime);
        services.getTimerService().setCallback(runtime);
        services.getStatementLifecycleSvc().init();
        ConfigurationOperationsImpl configOps = new ConfigurationOperationsImpl(services.getEventAdapterService(), services.getEngineImportService(), services.getVariableService());
        EPAdministratorImpl admin = new EPAdministratorImpl(services, configOps);
        if (this.configSnapshot.getEngineDefaults().getThreading().isInternalTimerEnabled()) {
            services.getTimerService().startInternalClock();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.engine = new EPServiceEngine(services, runtime, admin);
        this.loadAdapters(this.configSnapshot, services);
        if (services.getExtensionServicesContext() != null) {
            services.getExtensionServicesContext().init();
        }
    }

    private void loadAdapters(ConfigurationInformation configuration, EPServicesContext services) {
        List<ConfigurationAdapterLoader> adapterLoaders = configuration.getAdapterLoaders();
        if (adapterLoaders == null || adapterLoaders.size() == 0) {
            return;
        }
        for (ConfigurationAdapterLoader config : adapterLoaders) {
            Object adapterLoaderObj;
            Class<?> adapterLoaderClass;
            String className = config.getClassName();
            try {
                adapterLoaderClass = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Failed to load adapter loader class '" + className + "'", ex);
            }
            try {
                adapterLoaderObj = adapterLoaderClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new ConfigurationException("Failed to instantiate adapter loader class '" + className + "' via default constructor", ex);
            }
            catch (IllegalAccessException ex) {
                throw new ConfigurationException("Illegal access to instantiate adapter loader class '" + className + "' via default constructor", ex);
            }
            AdapterLoader adapterLoader = (AdapterLoader)adapterLoaderObj;
            adapterLoader.init(config.getLoaderName(), config.getConfigProperties(), this);
            try {
                services.getEngineEnvContext().bind("adapter-loader/" + config.getLoaderName(), (Object)adapterLoader);
            }
            catch (NamingException e) {
                throw new EPException("Failed to use context to bind adapter loader", e);
            }
        }
    }

    private ConfigurationInformation takeSnapshot(Configuration configuration) {
        try {
            return (ConfigurationInformation)SerializableObjectCopier.copy(configuration);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to snapshot configuration instance through serialization : " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to snapshot configuration instance through serialization : " + e.getMessage(), e);
        }
    }

    private static class EPServiceEngine {
        private EPServicesContext services;
        private EPRuntimeImpl runtime;
        private EPAdministratorImpl admin;

        public EPServiceEngine(EPServicesContext services, EPRuntimeImpl runtime, EPAdministratorImpl admin) {
            this.services = services;
            this.runtime = runtime;
            this.admin = admin;
        }

        public EPServicesContext getServices() {
            return this.services;
        }

        public EPRuntimeImpl getRuntime() {
            return this.runtime;
        }

        public EPAdministratorImpl getAdmin() {
            return this.admin;
        }
    }
}

