/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.esper.client.ConfigurationEventTypeLegacy;
import net.esper.client.ConfigurationEventTypeXMLDOM;
import net.esper.client.ConfigurationException;
import net.esper.client.ConfigurationInformation;
import net.esper.client.ConfigurationPlugInAggregationFunction;
import net.esper.client.ConfigurationVariable;
import net.esper.client.EPServiceProvider;
import net.esper.core.EPServicesContext;
import net.esper.core.EPServicesContextFactory;
import net.esper.core.EngineEnvContext;
import net.esper.core.StatementContextFactoryDefault;
import net.esper.core.StatementLifecycleSvcImpl;
import net.esper.core.StatementLockFactoryImpl;
import net.esper.eql.core.EngineImportException;
import net.esper.eql.core.EngineImportService;
import net.esper.eql.core.EngineImportServiceImpl;
import net.esper.eql.core.EngineSettingsService;
import net.esper.eql.db.DatabaseConfigService;
import net.esper.eql.db.DatabaseConfigServiceImpl;
import net.esper.eql.named.NamedWindowServiceImpl;
import net.esper.eql.spec.PluggableObjectCollection;
import net.esper.eql.variable.VariableExistsException;
import net.esper.eql.variable.VariableService;
import net.esper.eql.variable.VariableServiceImpl;
import net.esper.eql.variable.VariableTypeException;
import net.esper.eql.view.OutputConditionFactoryDefault;
import net.esper.event.EventAdapterException;
import net.esper.event.EventAdapterService;
import net.esper.event.EventAdapterServiceImpl;
import net.esper.filter.FilterService;
import net.esper.filter.FilterServiceProvider;
import net.esper.schedule.ScheduleBucket;
import net.esper.schedule.SchedulingService;
import net.esper.schedule.SchedulingServiceProvider;
import net.esper.timer.TimerServiceImpl;
import net.esper.util.JavaClassHelper;
import net.esper.util.ManagedReadWriteLock;
import net.esper.view.stream.StreamFactoryService;
import net.esper.view.stream.StreamFactoryServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPServicesContextFactoryDefault
implements EPServicesContextFactory {
    @Override
    public EPServicesContext createServicesContext(EPServiceProvider epServiceProvider, ConfigurationInformation configSnapshot) {
        EventAdapterServiceImpl eventAdapterService = new EventAdapterServiceImpl();
        EPServicesContextFactoryDefault.init(eventAdapterService, configSnapshot);
        ManagedReadWriteLock eventProcessingRWLock = new ManagedReadWriteLock("EventProcLock", false);
        SchedulingService schedulingService = SchedulingServiceProvider.newService();
        EngineImportService engineImportService = EPServicesContextFactoryDefault.makeEngineImportService(configSnapshot);
        EngineSettingsService engineSettingsService = new EngineSettingsService(configSnapshot.getEngineDefaults());
        DatabaseConfigService databaseConfigService = EPServicesContextFactoryDefault.makeDatabaseRefService(configSnapshot, schedulingService);
        PluggableObjectCollection plugInViews = new PluggableObjectCollection();
        plugInViews.addViews(configSnapshot.getPlugInViews());
        PluggableObjectCollection plugInPatternObj = new PluggableObjectCollection();
        plugInPatternObj.addPatternObjects(configSnapshot.getPlugInPatternObjects());
        EngineEnvContext jndiContext = new EngineEnvContext();
        StatementContextFactoryDefault statementContextFactory = new StatementContextFactoryDefault(plugInViews, plugInPatternObj);
        OutputConditionFactoryDefault outputConditionFactory = new OutputConditionFactoryDefault();
        long msecTimerResolution = configSnapshot.getEngineDefaults().getThreading().getInternalTimerMsecResolution();
        if (msecTimerResolution <= 0L) {
            throw new ConfigurationException("Timer resolution configuration not set to a valid value, expecting a non-zero value");
        }
        TimerServiceImpl timerService = new TimerServiceImpl(msecTimerResolution);
        VariableServiceImpl variableService = new VariableServiceImpl(configSnapshot.getEngineDefaults().getVariables().getMsecVersionRelease(), schedulingService, null);
        EPServicesContextFactoryDefault.initVariables(variableService, configSnapshot.getVariables());
        StatementLockFactoryImpl statementLockFactory = new StatementLockFactoryImpl();
        StreamFactoryService streamFactoryService = StreamFactoryServiceProvider.newService(configSnapshot.getEngineDefaults().getViewResources().isShareViews());
        FilterService filterService = FilterServiceProvider.newService();
        NamedWindowServiceImpl namedWindowService = new NamedWindowServiceImpl(statementLockFactory, variableService);
        EPServicesContext services = new EPServicesContext(epServiceProvider.getURI(), schedulingService, eventAdapterService, engineImportService, engineSettingsService, databaseConfigService, plugInViews, statementLockFactory, eventProcessingRWLock, null, jndiContext, statementContextFactory, plugInPatternObj, outputConditionFactory, timerService, filterService, streamFactoryService, namedWindowService, variableService);
        StatementLifecycleSvcImpl statementLifecycleSvc = new StatementLifecycleSvcImpl(epServiceProvider, services);
        services.setStatementLifecycleSvc(statementLifecycleSvc);
        return services;
    }

    protected static void initVariables(VariableService variableService, Map<String, ConfigurationVariable> variables) {
        for (Map.Entry<String, ConfigurationVariable> entry : variables.entrySet()) {
            try {
                variableService.createNewVariable(entry.getKey(), entry.getValue().getType(), entry.getValue().getInitializationValue(), null);
            }
            catch (VariableExistsException e) {
                throw new ConfigurationException("Error configuring variables: " + e.getMessage(), e);
            }
            catch (VariableTypeException e) {
                throw new ConfigurationException("Error configuring variables: " + e.getMessage(), e);
            }
        }
    }

    protected static void init(EventAdapterService eventAdapterService, ConfigurationInformation configSnapshot) {
        HashMap<String, ConfigurationEventTypeLegacy> classLegacyInfo = new HashMap<String, ConfigurationEventTypeLegacy>();
        for (Map.Entry<String, String> entry : configSnapshot.getEventTypeAliases().entrySet()) {
            String aliasName = entry.getKey();
            String className = entry.getValue();
            ConfigurationEventTypeLegacy legacyDef = configSnapshot.getEventTypesLegacy().get(aliasName);
            if (legacyDef == null) continue;
            classLegacyInfo.put(className, legacyDef);
        }
        eventAdapterService.setClassLegacyConfigs(classLegacyInfo);
        eventAdapterService.setDefaultPropertyResolutionStyle(configSnapshot.getEngineDefaults().getEventMeta().getClassPropertyResolutionStyle());
        Map<String, String> javaClassAliases = configSnapshot.getEventTypeAliases();
        for (Map.Entry<String, String> entry : javaClassAliases.entrySet()) {
            try {
                String aliasName = entry.getKey();
                eventAdapterService.addBeanType(aliasName, entry.getValue(), false);
            }
            catch (EventAdapterException ex) {
                throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
            }
        }
        Map<String, ConfigurationEventTypeXMLDOM> xmlDOMAliases = configSnapshot.getEventTypesXMLDOM();
        for (Map.Entry<String, ConfigurationEventTypeXMLDOM> entry : xmlDOMAliases.entrySet()) {
            try {
                eventAdapterService.addXMLDOMType(entry.getKey(), entry.getValue());
            }
            catch (EventAdapterException ex) {
                throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
            }
        }
        Map<String, Properties> mapAliases = configSnapshot.getEventTypesMapEvents();
        for (Map.Entry<String, Properties> entry : mapAliases.entrySet()) {
            try {
                Map<String, Class> propertyTypes = EPServicesContextFactoryDefault.createPropertyTypes(entry.getValue());
                eventAdapterService.addMapType(entry.getKey(), propertyTypes);
            }
            catch (EventAdapterException ex) {
                throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
            }
        }
    }

    protected static EngineImportService makeEngineImportService(ConfigurationInformation configSnapshot) {
        EngineImportServiceImpl engineImportService = new EngineImportServiceImpl();
        engineImportService.addMethodRefs(configSnapshot.getMethodInvocationReferences());
        try {
            for (String importName : configSnapshot.getImports()) {
                engineImportService.addImport(importName);
            }
            for (ConfigurationPlugInAggregationFunction config : configSnapshot.getPlugInAggregationFunctions()) {
                engineImportService.addAggregation(config.getName(), config.getFunctionClassName());
            }
        }
        catch (EngineImportException ex) {
            throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
        }
        return engineImportService;
    }

    protected static DatabaseConfigService makeDatabaseRefService(ConfigurationInformation configSnapshot, SchedulingService schedulingService) {
        DatabaseConfigServiceImpl databaseConfigService = null;
        try {
            ScheduleBucket allStatementsBucket = schedulingService.allocateBucket();
            databaseConfigService = new DatabaseConfigServiceImpl(configSnapshot.getDatabaseReferences(), schedulingService, allStatementsBucket);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
        }
        return databaseConfigService;
    }

    private static Map<String, Class> createPropertyTypes(Properties properties) {
        HashMap<String, Class> propertyTypes = new HashMap<String, Class>();
        for (Object property : properties.keySet()) {
            String className = (String)properties.get(property);
            Class clazz = JavaClassHelper.getClassForSimpleName(className);
            propertyTypes.put((String)property, clazz);
        }
        return propertyTypes;
    }
}

