/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import java.util.Iterator;
import net.esper.client.EPServiceProvider;
import net.esper.client.EPStatementState;
import net.esper.client.SafeIterator;
import net.esper.client.StatementAwareUpdateListener;
import net.esper.client.UpdateListener;
import net.esper.collection.SafeIteratorImpl;
import net.esper.core.EPStatementHandle;
import net.esper.core.EPStatementListenerSet;
import net.esper.core.EPStatementSPI;
import net.esper.core.StatementLifecycleSvc;
import net.esper.core.UpdateDispatchViewBase;
import net.esper.core.UpdateDispatchViewBlockingSpin;
import net.esper.core.UpdateDispatchViewBlockingWait;
import net.esper.core.UpdateDispatchViewNonBlocking;
import net.esper.dispatch.DispatchService;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.Viewable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPStatementImpl
implements EPStatementSPI {
    private final EPStatementListenerSet statementListenerSet;
    private final String statementId;
    private final String statementName;
    private final String expressionText;
    private boolean isPattern;
    private UpdateDispatchViewBase dispatchChildView;
    private StatementLifecycleSvc statementLifecycleSvc;
    private VariableService variableService;
    private long timeLastStateChange;
    private Viewable parentView;
    private EPStatementState currentState;
    private EventType eventType;
    private EPStatementHandle epStatementHandle;

    public EPStatementImpl(EPServiceProvider epServiceProvider, String statementId, String statementName, String expressionText, boolean isPattern, DispatchService dispatchService, StatementLifecycleSvc statementLifecycleSvc, long timeLastStateChange, boolean isBlockingDispatch, boolean isSpinBlockingDispatch, long msecBlockingTimeout, EPStatementHandle epStatementHandle, VariableService variableService) {
        this.isPattern = isPattern;
        this.statementId = statementId;
        this.statementName = statementName;
        this.expressionText = expressionText;
        this.statementLifecycleSvc = statementLifecycleSvc;
        this.statementListenerSet = new EPStatementListenerSet();
        this.dispatchChildView = isBlockingDispatch ? (isSpinBlockingDispatch ? new UpdateDispatchViewBlockingSpin(epServiceProvider, this, this.statementListenerSet, dispatchService, msecBlockingTimeout) : new UpdateDispatchViewBlockingWait(epServiceProvider, this, this.statementListenerSet, dispatchService, msecBlockingTimeout)) : new UpdateDispatchViewNonBlocking(epServiceProvider, this, this.statementListenerSet, dispatchService);
        this.currentState = EPStatementState.STOPPED;
        this.timeLastStateChange = timeLastStateChange;
        this.epStatementHandle = epStatementHandle;
        this.variableService = variableService;
    }

    @Override
    public String getStatementId() {
        return this.statementId;
    }

    @Override
    public void start() {
        if (this.statementLifecycleSvc == null) {
            throw new IllegalStateException("Cannot start statement, statement is in destroyed state");
        }
        this.statementLifecycleSvc.start(this.statementId);
    }

    @Override
    public void stop() {
        if (this.statementLifecycleSvc == null) {
            throw new IllegalStateException("Cannot stop statement, statement is in destroyed state");
        }
        this.statementLifecycleSvc.stop(this.statementId);
        this.dispatchChildView.dispatchOnStop();
        this.dispatchChildView.clear();
    }

    @Override
    public void destroy() {
        if (this.currentState == EPStatementState.DESTROYED) {
            throw new IllegalStateException("Statement already destroyed");
        }
        this.statementLifecycleSvc.destroy(this.statementId);
        this.parentView = null;
        this.eventType = null;
        this.dispatchChildView = null;
        this.statementLifecycleSvc = null;
    }

    @Override
    public EPStatementState getState() {
        return this.currentState;
    }

    @Override
    public void setCurrentState(EPStatementState currentState, long timeLastStateChange) {
        this.currentState = currentState;
        this.timeLastStateChange = timeLastStateChange;
    }

    @Override
    public void setParentView(Viewable viewable) {
        if (viewable == null) {
            if (this.parentView != null) {
                this.parentView.removeView(this.dispatchChildView);
            }
            this.parentView = null;
        } else {
            this.parentView = viewable;
            this.parentView.addView(this.dispatchChildView);
            this.eventType = this.parentView.getEventType();
        }
    }

    @Override
    public String getText() {
        return this.expressionText;
    }

    @Override
    public String getName() {
        return this.statementName;
    }

    @Override
    public Iterator<EventBean> iterator() {
        this.variableService.setLocalVersion();
        if (this.parentView == null) {
            return null;
        }
        if (this.isPattern) {
            return this.dispatchChildView.iterator();
        }
        return this.parentView.iterator();
    }

    @Override
    public SafeIterator<EventBean> safeIterator() {
        if (this.parentView == null) {
            return null;
        }
        this.epStatementHandle.getStatementLock().acquireLock(null);
        this.variableService.setLocalVersion();
        if (this.isPattern) {
            return new SafeIteratorImpl<EventBean>(this.epStatementHandle.getStatementLock(), this.dispatchChildView.iterator());
        }
        return new SafeIteratorImpl<EventBean>(this.epStatementHandle.getStatementLock(), this.parentView.iterator());
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public EPStatementListenerSet getListenerSet() {
        return this.statementListenerSet;
    }

    @Override
    public void setListeners(EPStatementListenerSet listenerSet) {
        this.statementListenerSet.setListeners(listenerSet);
        if (this.dispatchChildView != null) {
            this.dispatchChildView.setUpdateListeners(listenerSet);
        }
    }

    @Override
    public void addListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        this.statementListenerSet.addListener(listener);
        this.statementLifecycleSvc.updatedListeners(this.statementId, this.statementName, this.statementListenerSet);
    }

    @Override
    public void removeListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        this.statementListenerSet.removeListener(listener);
        this.statementLifecycleSvc.updatedListeners(this.statementId, this.statementName, this.statementListenerSet);
    }

    @Override
    public void removeAllListeners() {
        this.statementListenerSet.removeAllListeners();
        this.statementLifecycleSvc.updatedListeners(this.statementId, this.statementName, this.statementListenerSet);
    }

    @Override
    public void addListener(StatementAwareUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        this.statementListenerSet.addListener(listener);
        this.statementLifecycleSvc.updatedListeners(this.statementId, this.statementName, this.statementListenerSet);
    }

    @Override
    public void removeListener(StatementAwareUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        this.statementListenerSet.removeListener(listener);
        this.statementLifecycleSvc.updatedListeners(this.statementId, this.statementName, this.statementListenerSet);
    }

    @Override
    public Iterator<StatementAwareUpdateListener> getStatementAwareListeners() {
        return this.statementListenerSet.getStmtAwareListeners().iterator();
    }

    @Override
    public Iterator<UpdateListener> getUpdateListeners() {
        return this.statementListenerSet.getListeners().iterator();
    }

    @Override
    public long getTimeLastStateChange() {
        return this.timeLastStateChange;
    }

    @Override
    public boolean isStarted() {
        return this.currentState == EPStatementState.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.currentState == EPStatementState.STOPPED;
    }

    @Override
    public boolean isDestroyed() {
        return this.currentState == EPStatementState.DESTROYED;
    }
}

