/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.esper.client.EPStatementException;
import net.esper.collection.FlushedEventBuffer;
import net.esper.collection.Pair;
import net.esper.collection.UniformPair;
import net.esper.core.EPServicesContext;
import net.esper.core.EPStatementStopMethod;
import net.esper.core.InternalEventRouter;
import net.esper.core.StatementContext;
import net.esper.core.SubSelectStreamCollection;
import net.esper.eql.core.MethodPollingViewableFactory;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.core.ResultSetProcessorFactory;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.StreamTypeServiceImpl;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.core.ViewResourceDelegateImpl;
import net.esper.eql.db.DatabasePollingViewableFactory;
import net.esper.eql.expression.ExprAggregateNode;
import net.esper.eql.expression.ExprEqualsNode;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprSubselectNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.join.JoinExecStrategyDispatchable;
import net.esper.eql.join.JoinExecutionStrategyImpl;
import net.esper.eql.join.JoinPreloadMethod;
import net.esper.eql.join.JoinPreloadMethodImpl;
import net.esper.eql.join.JoinSetComposer;
import net.esper.eql.join.JoinSetFilter;
import net.esper.eql.join.plan.FilterExprAnalyzer;
import net.esper.eql.join.plan.QueryGraph;
import net.esper.eql.join.table.EventTable;
import net.esper.eql.join.table.PropertyIndTableCoerceAdd;
import net.esper.eql.join.table.PropertyIndexedEventTable;
import net.esper.eql.join.table.UnindexedEventTable;
import net.esper.eql.lookup.FullTableScanLookupStrategy;
import net.esper.eql.lookup.IndexedTableLookupStrategy;
import net.esper.eql.lookup.IndexedTableLookupStrategyCoercing;
import net.esper.eql.lookup.JoinedPropDesc;
import net.esper.eql.lookup.TableLookupStrategy;
import net.esper.eql.named.NamedWindowConsumerView;
import net.esper.eql.named.NamedWindowProcessor;
import net.esper.eql.named.NamedWindowRootView;
import net.esper.eql.named.NamedWindowTailView;
import net.esper.eql.named.NotADataWindowViewCapability;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.eql.spec.CreateVariableDesc;
import net.esper.eql.spec.DBStatementStreamSpec;
import net.esper.eql.spec.FilterStreamSpecCompiled;
import net.esper.eql.spec.MethodStreamSpec;
import net.esper.eql.spec.NamedWindowConsumerStreamSpec;
import net.esper.eql.spec.OnTriggerSetAssignment;
import net.esper.eql.spec.OnTriggerSetDesc;
import net.esper.eql.spec.OnTriggerWindowDesc;
import net.esper.eql.spec.OuterJoinDesc;
import net.esper.eql.spec.PatternStreamSpecCompiled;
import net.esper.eql.spec.SelectClauseSpec;
import net.esper.eql.spec.SelectClauseStreamSelectorEnum;
import net.esper.eql.spec.StatementSpecCompiled;
import net.esper.eql.spec.StreamSpecCompiled;
import net.esper.eql.variable.CreateVariableView;
import net.esper.eql.variable.OnSetVariableView;
import net.esper.eql.variable.VariableDeclarationException;
import net.esper.eql.variable.VariableExistsException;
import net.esper.eql.view.FilterExprView;
import net.esper.eql.view.IStreamRStreamSelectorView;
import net.esper.eql.view.InternalRouteView;
import net.esper.eql.view.OutputProcessView;
import net.esper.eql.view.OutputProcessViewFactory;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.pattern.EvalRootNode;
import net.esper.pattern.PatternContext;
import net.esper.pattern.PatternMatchCallback;
import net.esper.pattern.PatternStopCallback;
import net.esper.util.JavaClassHelper;
import net.esper.util.ManagedLock;
import net.esper.util.StopCallback;
import net.esper.view.EventStream;
import net.esper.view.HistoricalEventViewable;
import net.esper.view.ValidatedView;
import net.esper.view.View;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryChain;
import net.esper.view.ViewProcessingException;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import net.esper.view.ZeroDepthStream;
import net.esper.view.internal.BufferObserver;
import net.esper.view.internal.BufferView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPStatementStartMethod {
    private final StatementSpecCompiled statementSpec;
    private final EPServicesContext services;
    private final StatementContext statementContext;
    private static final Log log = LogFactory.getLog(EPStatementStartMethod.class);

    public EPStatementStartMethod(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) {
        this.statementSpec = statementSpec;
        this.services = services;
        this.statementContext = statementContext;
    }

    public Pair<Viewable, EPStatementStopMethod> start(boolean isNewStatement) throws ExprValidationException, ViewProcessingException {
        this.statementContext.getVariableService().setLocalVersion();
        if (this.statementSpec.getOnTriggerDesc() != null) {
            return this.startOnTrigger();
        }
        if (this.statementSpec.getCreateWindowDesc() != null) {
            return this.startCreateWindow();
        }
        if (this.statementSpec.getCreateVariableDesc() != null) {
            return this.startCreateVariable(isNewStatement);
        }
        return this.startSelect();
    }

    private Pair<Viewable, EPStatementStopMethod> startOnTrigger() throws ExprValidationException, ViewProcessingException {
        ViewSupport onExprView;
        Viewable eventStreamParentViewable;
        final LinkedList<PatternStopCallback> stopCallbacks = new LinkedList<PatternStopCallback>();
        final StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(0);
        if (streamSpec instanceof FilterStreamSpecCompiled) {
            FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
            Pair<EventStream, ManagedLock> streamLockPair = this.services.getStreamService().createStream(filterStreamSpec.getFilterSpec(), this.services.getFilterService(), this.statementContext.getEpStatementHandle(), false);
            eventStreamParentViewable = streamLockPair.getFirst();
            if (streamLockPair.getSecond() != null) {
                this.statementContext.getEpStatementHandle().setStatementLock(streamLockPair.getSecond());
            }
        } else if (streamSpec instanceof PatternStreamSpecCompiled) {
            PatternStreamSpecCompiled patternStreamSpec = (PatternStreamSpecCompiled)streamSpec;
            final EventType eventType = this.services.getEventAdapterService().createAnonymousCompositeType(patternStreamSpec.getTaggedEventTypes());
            final ZeroDepthStream sourceEventStream = new ZeroDepthStream(eventType);
            eventStreamParentViewable = sourceEventStream;
            EvalRootNode rootNode = new EvalRootNode();
            rootNode.addChildNode(patternStreamSpec.getEvalNode());
            PatternMatchCallback callback = new PatternMatchCallback(){

                @Override
                public void matchFound(Map<String, EventBean> matchEvent) {
                    EventBean compositeEvent = EPStatementStartMethod.this.statementContext.getEventAdapterService().adapterForCompositeEvent(eventType, matchEvent);
                    sourceEventStream.insert(compositeEvent);
                }
            };
            PatternContext patternContext = this.statementContext.getPatternContextFactory().createContext(this.statementContext, 0, rootNode);
            PatternStopCallback patternStopCallback = rootNode.start(callback, patternContext);
            stopCallbacks.add(patternStopCallback);
        } else if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
            eventStreamParentViewable = processor.addConsumer(namedSpec.getFilterExpressions(), this.statementContext.getEpStatementHandle(), this.statementContext.getStatementStopService());
        } else {
            throw new ExprValidationException("Unknown stream specification type: " + streamSpec);
        }
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            public void stop() {
                EPStatementStartMethod.this.statementContext.getStatementStopService().fireStatementStopped();
                if (streamSpec instanceof FilterStreamSpecCompiled) {
                    FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
                    EPStatementStartMethod.this.services.getStreamService().dropStream(filterStreamSpec.getFilterSpec(), EPStatementStartMethod.this.services.getFilterService(), false);
                }
                for (StopCallback stopCallback : stopCallbacks) {
                    stopCallback.stop();
                }
            }
        };
        EventType streamEventType = eventStreamParentViewable.getEventType();
        if (this.statementSpec.getOnTriggerDesc() instanceof OnTriggerWindowDesc) {
            String streamAlias;
            OnTriggerWindowDesc onTriggerDesc = (OnTriggerWindowDesc)this.statementSpec.getOnTriggerDesc();
            NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(onTriggerDesc.getWindowName());
            EventType namedWindowType = processor.getNamedWindowType();
            String namedWindowAlias = onTriggerDesc.getOptionalAsName();
            if (namedWindowAlias == null) {
                namedWindowAlias = "stream_0";
            }
            if ((streamAlias = streamSpec.getOptionalStreamName()) == null) {
                streamAlias = "stream_1";
            }
            StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{namedWindowType, streamEventType}, new String[]{namedWindowAlias, streamAlias});
            ResultSetProcessor optionalResultSetProcessor = ResultSetProcessorFactory.getProcessor(this.statementSpec.getSelectClauseSpec(), this.statementSpec.getInsertIntoDesc(), this.statementSpec.getGroupByExpressions(), this.statementSpec.getHavingExprRootNode(), this.statementSpec.getOutputLimitSpec(), this.statementSpec.getOrderByList(), typeService, this.services.getEventAdapterService(), this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService());
            ExprNode validatedJoin = this.validateJoinNamedWindow(this.statementSpec.getFilterRootNode(), namedWindowType, namedWindowAlias, streamEventType, streamAlias);
            InternalEventRouter routerService = this.statementSpec.getInsertIntoDesc() == null ? null : this.services.getInternalEventRouter();
            onExprView = processor.addOnExpr(onTriggerDesc, validatedJoin, streamEventType, this.statementContext.getStatementStopService(), routerService, optionalResultSetProcessor, this.statementContext.getEpStatementHandle());
            eventStreamParentViewable.addView(onExprView);
        } else {
            OnTriggerSetDesc desc = (OnTriggerSetDesc)this.statementSpec.getOnTriggerDesc();
            StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{streamEventType}, new String[]{streamSpec.getOptionalStreamName()});
            for (OnTriggerSetAssignment assignment : desc.getAssignments()) {
                ExprNode validated = assignment.getExpression().getValidatedSubtree(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService());
                assignment.setExpression(validated);
            }
            onExprView = new OnSetVariableView(desc, this.statementContext.getEventAdapterService(), this.statementContext.getVariableService());
            eventStreamParentViewable.addView(onExprView);
        }
        log.debug(".start Statement start completed");
        return new Pair<Viewable, EPStatementStopMethod>(onExprView, stopMethod);
    }

    private Pair<Viewable, EPStatementStopMethod> startCreateWindow() throws ExprValidationException, ViewProcessingException {
        final FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)this.statementSpec.getStreamSpecs().get(0);
        String windowName = this.statementSpec.getCreateWindowDesc().getWindowName();
        EventType windowType = filterStreamSpec.getFilterSpec().getEventType();
        this.services.getNamedWindowService().addProcessor(windowName, windowType);
        Pair<EventStream, ManagedLock> streamLockPair = this.services.getStreamService().createStream(filterStreamSpec.getFilterSpec(), this.services.getFilterService(), this.statementContext.getEpStatementHandle(), false);
        Viewable eventStreamParentViewable = streamLockPair.getFirst();
        if (streamLockPair.getSecond() != null) {
            this.statementContext.getEpStatementHandle().setStatementLock(streamLockPair.getSecond());
        }
        ViewFactoryChain unmaterializedViewChain = this.services.getViewService().createFactories(0, eventStreamParentViewable.getEventType(), filterStreamSpec.getViewSpecs(), this.statementContext);
        NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(this.statementSpec.getCreateWindowDesc().getWindowName());
        NamedWindowRootView rootView = processor.getRootView();
        eventStreamParentViewable.addView(rootView);
        ViewResourceDelegateImpl viewResourceDelegate = new ViewResourceDelegateImpl(new ViewFactoryChain[]{unmaterializedViewChain}, this.statementContext);
        if (!viewResourceDelegate.requestCapability(0, new RemoveStreamViewCapability(), null)) {
            throw new ExprValidationException("Named windows require one or more child views that are data window views");
        }
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            public void stop() {
                EPStatementStartMethod.this.statementContext.getStatementStopService().fireStatementStopped();
                EPStatementStartMethod.this.services.getStreamService().dropStream(filterStreamSpec.getFilterSpec(), EPStatementStartMethod.this.services.getFilterService(), false);
                String windowName = EPStatementStartMethod.this.statementSpec.getCreateWindowDesc().getWindowName();
                EPStatementStartMethod.this.services.getNamedWindowService().removeProcessor(windowName);
            }
        };
        Viewable finalView = this.services.getViewService().createViews(rootView, unmaterializedViewChain.getViewFactoryChain(), this.statementContext);
        NamedWindowTailView tailView = processor.getTailView();
        finalView.addView(tailView);
        finalView = tailView;
        log.debug(".start Statement start completed");
        return new Pair<Viewable, EPStatementStopMethod>(finalView, stopMethod);
    }

    private Pair<Viewable, EPStatementStopMethod> startCreateVariable(boolean isNewStatement) throws ExprValidationException, ViewProcessingException {
        Class type;
        CreateVariableDesc createDesc = this.statementSpec.getCreateVariableDesc();
        try {
            type = JavaClassHelper.getClassForSimpleName(createDesc.getVariableType());
        }
        catch (Throwable t) {
            throw new ExprValidationException("Cannot create variable '" + createDesc.getVariableName() + "', type '" + createDesc.getVariableType() + "' is not a recognized type");
        }
        Object value = null;
        if (createDesc.getAssignment() != null) {
            StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[0], new String[0]);
            ExprNode validated = createDesc.getAssignment().getValidatedSubtree(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService());
            value = validated.evaluate(null, true);
        }
        try {
            this.services.getVariableService().createNewVariable(createDesc.getVariableName(), type, value, this.statementContext.getExtensionServicesContext());
        }
        catch (VariableExistsException ex) {
            if (isNewStatement) {
                throw new ExprValidationException("Cannot create variable: " + ex.getMessage());
            }
            if (this.services.getVariableService().getReader(createDesc.getVariableName()).getType() != type) {
                throw new ExprValidationException("Cannot create variable: " + ex.getMessage());
            }
        }
        catch (VariableDeclarationException ex) {
            throw new ExprValidationException("Cannot create variable: " + ex.getMessage());
        }
        CreateVariableView createView = new CreateVariableView(this.services.getEventAdapterService(), this.services.getVariableService(), createDesc.getVariableName());
        this.services.getVariableService().registerCallback(this.services.getVariableService().getReader(createDesc.getVariableName()).getVariableNumber(), createView);
        return new Pair<Viewable, EPStatementStopMethod>(createView, new EPStatementStopMethod(){

            public void stop() {
            }
        });
    }

    private Pair<Viewable, EPStatementStopMethod> startSelect() throws ExprValidationException, ViewProcessingException {
        Viewable finalView;
        String[] streamNames = EPStatementStartMethod.determineStreamNames(this.statementSpec.getStreamSpecs());
        final boolean isJoin = this.statementSpec.getStreamSpecs().size() > 1;
        SubSelectStreamCollection subSelectStreamDesc = this.createSubSelectStreams(isJoin);
        int numStreams = streamNames.length;
        final LinkedList<StopCallback> stopCallbacks = new LinkedList<StopCallback>();
        Viewable[] eventStreamParentViewable = new Viewable[numStreams];
        ViewFactoryChain[] unmaterializedViewChain = new ViewFactoryChain[numStreams];
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            HistoricalEventViewable historicalEventViewable;
            StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(i);
            if (streamSpec instanceof FilterStreamSpecCompiled) {
                FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
                Pair<EventStream, ManagedLock> streamLockPair = this.services.getStreamService().createStream(filterStreamSpec.getFilterSpec(), this.services.getFilterService(), this.statementContext.getEpStatementHandle(), isJoin);
                eventStreamParentViewable[i] = streamLockPair.getFirst();
                if (streamLockPair.getSecond() != null) {
                    this.statementContext.getEpStatementHandle().setStatementLock(streamLockPair.getSecond());
                }
                unmaterializedViewChain[i] = this.services.getViewService().createFactories(i, eventStreamParentViewable[i].getEventType(), streamSpec.getViewSpecs(), this.statementContext);
                continue;
            }
            if (streamSpec instanceof PatternStreamSpecCompiled) {
                PatternStreamSpecCompiled patternStreamSpec = (PatternStreamSpecCompiled)streamSpec;
                final EventType eventType = this.services.getEventAdapterService().createAnonymousCompositeType(patternStreamSpec.getTaggedEventTypes());
                final ZeroDepthStream sourceEventStream = new ZeroDepthStream(eventType);
                eventStreamParentViewable[i] = sourceEventStream;
                unmaterializedViewChain[i] = this.services.getViewService().createFactories(i, sourceEventStream.getEventType(), streamSpec.getViewSpecs(), this.statementContext);
                EvalRootNode rootNode = new EvalRootNode();
                rootNode.addChildNode(patternStreamSpec.getEvalNode());
                PatternMatchCallback callback = new PatternMatchCallback(){

                    @Override
                    public void matchFound(Map<String, EventBean> matchEvent) {
                        EventBean compositeEvent = EPStatementStartMethod.this.statementContext.getEventAdapterService().adapterForCompositeEvent(eventType, matchEvent);
                        sourceEventStream.insert(compositeEvent);
                    }
                };
                PatternContext patternContext = this.statementContext.getPatternContextFactory().createContext(this.statementContext, i, rootNode);
                PatternStopCallback patternStopCallback = rootNode.start(callback, patternContext);
                stopCallbacks.add(patternStopCallback);
                continue;
            }
            if (streamSpec instanceof DBStatementStreamSpec) {
                if (!streamSpec.getViewSpecs().isEmpty()) {
                    throw new ExprValidationException("Historical data joins do not allow views onto the data, view '" + streamSpec.getViewSpecs().get(0).getObjectNamespace() + ':' + streamSpec.getViewSpecs().get(0).getObjectName() + "' is not valid in this context");
                }
                DBStatementStreamSpec sqlStreamSpec = (DBStatementStreamSpec)streamSpec;
                historicalEventViewable = DatabasePollingViewableFactory.createDBStatementView(i, sqlStreamSpec, this.services.getDatabaseRefService(), this.services.getEventAdapterService(), this.statementContext.getEpStatementHandle());
                unmaterializedViewChain[i] = new ViewFactoryChain(historicalEventViewable.getEventType(), new LinkedList<ViewFactory>());
                eventStreamParentViewable[i] = historicalEventViewable;
                stopCallbacks.add(historicalEventViewable);
                continue;
            }
            if (streamSpec instanceof MethodStreamSpec) {
                if (!streamSpec.getViewSpecs().isEmpty()) {
                    throw new ExprValidationException("Method data joins do not allow views onto the data, view '" + streamSpec.getViewSpecs().get(0).getObjectNamespace() + ':' + streamSpec.getViewSpecs().get(0).getObjectName() + "' is not valid in this context");
                }
                MethodStreamSpec methodStreamSpec = (MethodStreamSpec)streamSpec;
                historicalEventViewable = MethodPollingViewableFactory.createPollMethodView(i, methodStreamSpec, this.services.getEventAdapterService(), this.statementContext.getEpStatementHandle(), this.statementContext.getMethodResolutionService(), this.services.getEngineImportService(), this.services.getSchedulingService(), this.statementContext.getScheduleBucket());
                unmaterializedViewChain[i] = new ViewFactoryChain(historicalEventViewable.getEventType(), new LinkedList<ViewFactory>());
                eventStreamParentViewable[i] = historicalEventViewable;
                stopCallbacks.add(historicalEventViewable);
                continue;
            }
            if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
                NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                NamedWindowConsumerView consumerView = processor.addConsumer(namedSpec.getFilterExpressions(), this.statementContext.getEpStatementHandle(), this.statementContext.getStatementStopService());
                eventStreamParentViewable[i] = consumerView;
                unmaterializedViewChain[i] = this.services.getViewService().createFactories(i, consumerView.getEventType(), namedSpec.getViewSpecs(), this.statementContext);
                ViewResourceDelegateImpl viewResourceDelegate = new ViewResourceDelegateImpl(unmaterializedViewChain, this.statementContext);
                viewResourceDelegate.requestCapability(i, new NotADataWindowViewCapability(), null);
                continue;
            }
            throw new ExprValidationException("Unknown stream specification type: " + streamSpec);
        }
        EventType[] streamEventTypes = new EventType[this.statementSpec.getStreamSpecs().size()];
        for (int i = 0; i < unmaterializedViewChain.length; ++i) {
            streamEventTypes[i] = unmaterializedViewChain[i].getEventType();
        }
        this.startSubSelect(subSelectStreamDesc, streamNames, streamEventTypes, stopCallbacks);
        final ArrayList<StreamSpecCompiled> statementStreamSpecs = new ArrayList<StreamSpecCompiled>();
        statementStreamSpecs.addAll(this.statementSpec.getStreamSpecs());
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(streamEventTypes, streamNames);
        ViewResourceDelegateImpl viewResourceDelegate = new ViewResourceDelegateImpl(unmaterializedViewChain, this.statementContext);
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            public void stop() {
                EPStatementStartMethod.this.statementContext.getStatementStopService().fireStatementStopped();
                for (StreamSpecCompiled streamSpec : statementStreamSpecs) {
                    if (!(streamSpec instanceof FilterStreamSpecCompiled)) continue;
                    FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
                    EPStatementStartMethod.this.services.getStreamService().dropStream(filterStreamSpec.getFilterSpec(), EPStatementStartMethod.this.services.getFilterService(), isJoin);
                }
                for (StopCallback stopCallback : stopCallbacks) {
                    stopCallback.stop();
                }
                for (ExprSubselectNode subselect : EPStatementStartMethod.this.statementSpec.getSubSelectExpressions()) {
                    StreamSpecCompiled subqueryStreamSpec = subselect.getStatementSpecCompiled().getStreamSpecs().get(0);
                    if (!(subqueryStreamSpec instanceof FilterStreamSpecCompiled)) continue;
                    FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)subselect.getStatementSpecCompiled().getStreamSpecs().get(0);
                    EPStatementStartMethod.this.services.getStreamService().dropStream(filterStreamSpec.getFilterSpec(), EPStatementStartMethod.this.services.getFilterService(), isJoin);
                }
            }
        };
        for (Viewable viewable : eventStreamParentViewable) {
            if (!(viewable instanceof ValidatedView)) continue;
            ValidatedView validatedView = (ValidatedView)((Object)viewable);
            validatedView.validate(typeService, this.statementContext.getMethodResolutionService(), this.statementContext.getSchedulingService(), this.statementContext.getVariableService());
        }
        ResultSetProcessor optionalResultSetProcessor = ResultSetProcessorFactory.getProcessor(this.statementSpec.getSelectClauseSpec(), this.statementSpec.getInsertIntoDesc(), this.statementSpec.getGroupByExpressions(), this.statementSpec.getHavingExprRootNode(), this.statementSpec.getOutputLimitSpec(), this.statementSpec.getOrderByList(), typeService, this.services.getEventAdapterService(), this.statementContext.getMethodResolutionService(), viewResourceDelegate, this.statementContext.getSchedulingService(), this.statementContext.getVariableService());
        this.validateNodes(typeService, this.statementContext.getMethodResolutionService(), viewResourceDelegate);
        Viewable[] streamViews = new Viewable[streamEventTypes.length];
        for (int i = 0; i < streamViews.length; ++i) {
            streamViews[i] = this.services.getViewService().createViews(eventStreamParentViewable[i], unmaterializedViewChain[i].getViewFactoryChain(), this.statementContext);
        }
        JoinPreloadMethod joinPreloadMethod = null;
        if (streamNames.length == 1) {
            finalView = this.handleSimpleSelect(streamViews[0], optionalResultSetProcessor, this.statementContext);
        } else {
            Pair<Viewable, JoinPreloadMethod> pair = this.handleJoin(streamNames, streamEventTypes, streamViews, optionalResultSetProcessor, this.statementSpec.getSelectStreamSelectorEnum(), this.statementContext, stopCallbacks);
            finalView = pair.getFirst();
            joinPreloadMethod = pair.getSecond();
        }
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(i);
            if (!(streamSpec instanceof NamedWindowConsumerStreamSpec)) continue;
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
            NamedWindowTailView consumerView = processor.getTailView();
            NamedWindowConsumerView view = (NamedWindowConsumerView)eventStreamParentViewable[i];
            ArrayList<EventBean> eventsInWindow = new ArrayList<EventBean>();
            for (EventBean aConsumerView : consumerView) {
                eventsInWindow.add(aConsumerView);
            }
            if (!eventsInWindow.isEmpty()) {
                EventBean[] newEvents = eventsInWindow.toArray(new EventBean[0]);
                view.update(newEvents, null);
            }
            if (joinPreloadMethod == null) continue;
            joinPreloadMethod.preloadFromBuffer(i);
        }
        if (this.statementSpec.getInsertIntoDesc() != null) {
            InternalRouteView routeView = new InternalRouteView(this.statementSpec.getInsertIntoDesc().isIStream(), this.services.getInternalEventRouter(), this.statementContext.getEpStatementHandle());
            finalView.addView(routeView);
            finalView = routeView;
        }
        if (this.statementSpec.getSelectStreamSelectorEnum() != SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH) {
            IStreamRStreamSelectorView streamSelectorView = new IStreamRStreamSelectorView(this.statementSpec.getSelectStreamSelectorEnum());
            finalView.addView(streamSelectorView);
            finalView = streamSelectorView;
        }
        log.debug(".start Statement start completed");
        return new Pair<Viewable, EPStatementStopMethod>(finalView, stopMethod);
    }

    private Pair<Viewable, JoinPreloadMethod> handleJoin(String[] streamNames, EventType[] streamTypes, Viewable[] streamViews, ResultSetProcessor optionalResultSetProcessor, SelectClauseStreamSelectorEnum selectStreamSelectorEnum, StatementContext statementContext, List<StopCallback> stopCallbacks) throws ExprValidationException {
        final JoinSetComposer composer = statementContext.getJoinSetComposerFactory().makeComposer(this.statementSpec.getOuterJoinDescList(), this.statementSpec.getFilterRootNode(), streamTypes, streamNames, streamViews, selectStreamSelectorEnum);
        stopCallbacks.add(new StopCallback(){

            public void stop() {
                composer.destroy();
            }
        });
        JoinSetFilter filter = new JoinSetFilter(this.statementSpec.getFilterRootNode());
        OutputProcessView indicatorView = OutputProcessViewFactory.makeView(optionalResultSetProcessor, this.statementSpec.getStreamSpecs().size(), this.statementSpec.getOutputLimitSpec(), statementContext);
        JoinExecutionStrategyImpl execution = new JoinExecutionStrategyImpl(composer, filter, indicatorView);
        indicatorView.setJoinExecutionStrategy(execution);
        JoinExecStrategyDispatchable joinStatementDispatch = new JoinExecStrategyDispatchable(execution, this.statementSpec.getStreamSpecs().size());
        statementContext.getEpStatementHandle().setOptionalDispatchable(joinStatementDispatch);
        JoinPreloadMethodImpl preloadMethod = new JoinPreloadMethodImpl(streamNames.length, composer);
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            BufferView buffer = new BufferView(i);
            streamViews[i].addView(buffer);
            buffer.setObserver(joinStatementDispatch);
            preloadMethod.setBuffer(buffer, i);
        }
        return new Pair<Viewable, JoinPreloadMethod>(indicatorView, preloadMethod);
    }

    protected static String[] determineStreamNames(List<StreamSpecCompiled> streams) {
        String[] streamNames = new String[streams.size()];
        for (int i = 0; i < streams.size(); ++i) {
            streamNames[i] = streams.get(i).getOptionalStreamName();
            if (streamNames[i] != null) continue;
            streamNames[i] = "stream_" + i;
        }
        return streamNames;
    }

    private void validateNodes(StreamTypeService typeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate) {
        if (this.statementSpec.getFilterRootNode() != null) {
            ExprNode optionalFilterNode = this.statementSpec.getFilterRootNode();
            try {
                optionalFilterNode = optionalFilterNode.getValidatedSubtree(typeService, methodResolutionService, viewResourceDelegate, this.statementContext.getSchedulingService(), this.statementContext.getVariableService());
                this.statementSpec.setFilterExprRootNode(optionalFilterNode);
                LinkedList<ExprAggregateNode> aggregateNodes = new LinkedList<ExprAggregateNode>();
                ExprAggregateNode.getAggregatesBottomUp(optionalFilterNode, aggregateNodes);
                if (!aggregateNodes.isEmpty()) {
                    throw new ExprValidationException("An aggregate function may not appear in a WHERE clause (use the HAVING clause)");
                }
            }
            catch (ExprValidationException ex) {
                log.debug(".validateNodes Validation exception for filter=" + optionalFilterNode.toExpressionString(), ex);
                throw new EPStatementException("Error validating expression: " + ex.getMessage(), this.statementContext.getExpression());
            }
        }
        for (int outerJoinCount = 0; outerJoinCount < this.statementSpec.getOuterJoinDescList().size(); ++outerJoinCount) {
            OuterJoinDesc outerJoinDesc = this.statementSpec.getOuterJoinDescList().get(outerJoinCount);
            UniformPair<Integer> streamIdPair = this.validateOuterJoinPropertyPair(outerJoinDesc.getLeftNode(), outerJoinDesc.getRightNode(), outerJoinCount, typeService, methodResolutionService, viewResourceDelegate);
            if (outerJoinDesc.getAdditionalLeftNodes() == null) continue;
            HashSet<Integer> streamSet = new HashSet<Integer>();
            streamSet.add(streamIdPair.getFirst());
            streamSet.add(streamIdPair.getSecond());
            for (int i = 0; i < outerJoinDesc.getAdditionalLeftNodes().length; ++i) {
                UniformPair<Integer> streamIdPairAdd = this.validateOuterJoinPropertyPair(outerJoinDesc.getAdditionalLeftNodes()[i], outerJoinDesc.getAdditionalRightNodes()[i], outerJoinCount, typeService, methodResolutionService, viewResourceDelegate);
                if (streamSet.contains(streamIdPairAdd.getFirst()) && streamSet.contains(streamIdPairAdd.getSecond())) continue;
                String message = "Outer join ON-clause columns must refer to properties of the same joined streams when using multiple columns in the on-clause";
                throw new EPStatementException("Error validating expression: " + message, this.statementContext.getExpression());
            }
        }
    }

    private UniformPair<Integer> validateOuterJoinPropertyPair(ExprIdentNode leftNode, ExprIdentNode rightNode, int outerJoinCount, StreamTypeService typeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate) {
        ExprNode equalsNode = new ExprEqualsNode(false);
        equalsNode.addChildNode(leftNode);
        equalsNode.addChildNode(rightNode);
        try {
            equalsNode = equalsNode.getValidatedSubtree(typeService, methodResolutionService, viewResourceDelegate, this.statementContext.getSchedulingService(), this.statementContext.getVariableService());
        }
        catch (ExprValidationException ex) {
            log.debug("Validation exception for outer join node=" + ((ExprNode)equalsNode).toExpressionString(), ex);
            throw new EPStatementException("Error validating expression: " + ex.getMessage(), this.statementContext.getExpression());
        }
        int streamIdLeft = leftNode.getStreamId();
        int streamIdRight = rightNode.getStreamId();
        if (streamIdLeft == streamIdRight) {
            String message = "Outer join ON-clause cannot refer to properties of the same stream";
            throw new EPStatementException("Error validating expression: " + message, this.statementContext.getExpression());
        }
        int expectedStreamJoined = outerJoinCount + 1;
        if (streamIdLeft != expectedStreamJoined && streamIdRight != expectedStreamJoined) {
            String message = "Outer join ON-clause must refer to at least one property of the joined stream for stream " + expectedStreamJoined;
            throw new EPStatementException("Error validating expression: " + message, this.statementContext.getExpression());
        }
        String badPropertyName = null;
        if (streamIdLeft > outerJoinCount + 1) {
            badPropertyName = leftNode.getResolvedPropertyName();
        }
        if (streamIdRight > outerJoinCount + 1) {
            badPropertyName = rightNode.getResolvedPropertyName();
        }
        if (badPropertyName != null) {
            String message = "Outer join ON-clause invalid scope for property '" + badPropertyName + "', expecting the current or a prior stream scope";
            throw new EPStatementException("Error validating expression: " + message, this.statementContext.getExpression());
        }
        return new UniformPair<Integer>(streamIdLeft, streamIdRight);
    }

    private Viewable handleSimpleSelect(Viewable view, ResultSetProcessor optionalResultSetProcessor, StatementContext statementContext) throws ExprValidationException {
        Viewable finalView = view;
        if (this.statementSpec.getFilterRootNode() != null) {
            FilterExprView filterView = new FilterExprView(this.statementSpec.getFilterRootNode());
            finalView.addView(filterView);
            finalView = filterView;
        }
        if (optionalResultSetProcessor != null || this.statementSpec.getOutputLimitSpec() != null) {
            OutputProcessView selectView = OutputProcessViewFactory.makeView(optionalResultSetProcessor, this.statementSpec.getStreamSpecs().size(), this.statementSpec.getOutputLimitSpec(), statementContext);
            finalView.addView(selectView);
            finalView = selectView;
        }
        return finalView;
    }

    private SubSelectStreamCollection createSubSelectStreams(boolean isJoin) throws ExprValidationException, ViewProcessingException {
        SubSelectStreamCollection subSelectStreamDesc = new SubSelectStreamCollection();
        int subselectStreamNumber = 1024;
        for (ExprSubselectNode subselect : this.statementSpec.getSubSelectExpressions()) {
            ViewFactoryChain viewFactoryChain;
            StatementSpecCompiled statementSpec = subselect.getStatementSpecCompiled();
            SelectClauseSpec selectClauseSpec = statementSpec.getSelectClauseSpec();
            if (statementSpec.getStreamSpecs().get(0) instanceof FilterStreamSpecCompiled) {
                FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)statementSpec.getStreamSpecs().get(0);
                if (filterStreamSpec.getViewSpecs().size() == 0) {
                    throw new ExprValidationException("Subqueries require one or more views to limit the stream, consider declaring a length or time window");
                }
                Pair<EventStream, ManagedLock> streamLockPair = this.services.getStreamService().createStream(filterStreamSpec.getFilterSpec(), this.services.getFilterService(), this.statementContext.getEpStatementHandle(), isJoin);
                Viewable viewable = streamLockPair.getFirst();
                viewFactoryChain = this.services.getViewService().createFactories(++subselectStreamNumber, viewable.getEventType(), filterStreamSpec.getViewSpecs(), this.statementContext);
                subselect.setRawEventType(viewFactoryChain.getEventType());
                subSelectStreamDesc.add(subselect, subselectStreamNumber, viewable, viewFactoryChain);
            } else {
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)statementSpec.getStreamSpecs().get(0);
                NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                NamedWindowConsumerView consumerView = processor.addConsumer(namedSpec.getFilterExpressions(), this.statementContext.getEpStatementHandle(), this.statementContext.getStatementStopService());
                viewFactoryChain = this.services.getViewService().createFactories(0, consumerView.getEventType(), namedSpec.getViewSpecs(), this.statementContext);
                subSelectStreamDesc.add(subselect, subselectStreamNumber, consumerView, viewFactoryChain);
            }
            if (selectClauseSpec.getSelectExprList().size() > 0) {
                ExprNode selectExpression = selectClauseSpec.getSelectExprList().get(0).getSelectExpression();
                LinkedList<ExprAggregateNode> aggExprNodes = new LinkedList<ExprAggregateNode>();
                ExprAggregateNode.getAggregatesBottomUp(selectExpression, aggExprNodes);
                if (aggExprNodes.size() > 0) {
                    throw new ExprValidationException("Aggregation functions are not supported within subqueries, consider using insert-into instead");
                }
            }
            if (statementSpec.getFilterRootNode() == null) continue;
            LinkedList<ExprAggregateNode> aggExprNodes = new LinkedList<ExprAggregateNode>();
            ExprAggregateNode.getAggregatesBottomUp(statementSpec.getFilterRootNode(), aggExprNodes);
            if (aggExprNodes.size() <= 0) continue;
            throw new ExprValidationException("Aggregation functions are not supported within subqueries, consider using insert-into instead");
        }
        return subSelectStreamDesc;
    }

    private void startSubSelect(SubSelectStreamCollection subSelectStreamDesc, String[] outerStreamNames, EventType[] outerEventTypes, List<StopCallback> stopCallbacks) throws ExprValidationException {
        for (ExprSubselectNode subselect : this.statementSpec.getSubSelectExpressions()) {
            ExprNode filterExpr;
            StatementSpecCompiled statementSpec = subselect.getStatementSpecCompiled();
            StreamSpecCompiled filterStreamSpec = statementSpec.getStreamSpecs().get(0);
            ViewFactoryChain viewFactoryChain = subSelectStreamDesc.getViewFactoryChain(subselect);
            EventType eventType = viewFactoryChain.getEventType();
            String subexpressionStreamName = filterStreamSpec.getOptionalStreamName();
            int subselectStreamNumber = subSelectStreamDesc.getStreamNumber(subselect);
            if (subexpressionStreamName == null) {
                subexpressionStreamName = "$subselect_" + subselectStreamNumber;
            }
            if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
                ViewResourceDelegateImpl viewResourceDelegate = new ViewResourceDelegateImpl(new ViewFactoryChain[]{viewFactoryChain}, this.statementContext);
                viewResourceDelegate.requestCapability(0, new NotADataWindowViewCapability(), null);
            }
            LinkedHashMap<String, EventType> namesAndTypes = new LinkedHashMap<String, EventType>();
            namesAndTypes.put(subexpressionStreamName, eventType);
            for (int i = 0; i < outerEventTypes.length; ++i) {
                namesAndTypes.put(outerStreamNames[i], outerEventTypes[i]);
            }
            StreamTypeServiceImpl subselectTypeService = new StreamTypeServiceImpl(namesAndTypes, true, true);
            ViewResourceDelegateImpl viewResourceDelegateSubselect = new ViewResourceDelegateImpl(new ViewFactoryChain[]{viewFactoryChain}, this.statementContext);
            SelectClauseSpec selectClauseSpec = subselect.getStatementSpecCompiled().getSelectClauseSpec();
            if (selectClauseSpec.getSelectExprList().size() > 0) {
                ExprNode selectExpression = selectClauseSpec.getSelectExprList().get(0).getSelectExpression();
                selectExpression = selectExpression.getValidatedSubtree(subselectTypeService, this.statementContext.getMethodResolutionService(), viewResourceDelegateSubselect, this.statementContext.getSchedulingService(), this.statementContext.getVariableService());
                subselect.setSelectClause(selectExpression);
                subselect.setSelectAsName(selectClauseSpec.getSelectExprList().get(0).getOptionalAsName());
            }
            if ((filterExpr = statementSpec.getFilterRootNode()) != null) {
                if (JavaClassHelper.getBoxedType((filterExpr = filterExpr.getValidatedSubtree(subselectTypeService, this.statementContext.getMethodResolutionService(), viewResourceDelegateSubselect, this.statementContext.getSchedulingService(), this.statementContext.getVariableService())).getType()) != Boolean.class) {
                    throw new ExprValidationException("Subselect filter expression must return a boolean value");
                }
                subselect.setFilterExpr(filterExpr);
            }
            Viewable viewableRoot = subSelectStreamDesc.getRootViewable(subselect);
            Viewable subselectView = this.services.getViewService().createViews(viewableRoot, viewFactoryChain.getViewFactoryChain(), this.statementContext);
            Pair<EventTable, TableLookupStrategy> indexPair = this.determineSubqueryIndex(filterExpr, eventType, outerEventTypes, subselectTypeService);
            subselect.setStrategy(indexPair.getSecond());
            final EventTable eventIndex = indexPair.getFirst();
            stopCallbacks.add(new StopCallback(){

                public void stop() {
                    eventIndex.clear();
                }
            });
            if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)filterStreamSpec;
                NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                NamedWindowTailView consumerView = processor.getTailView();
                ArrayList<EventBean> eventsInWindow = new ArrayList<EventBean>();
                Iterator<EventBean> it = consumerView.iterator();
                while (it.hasNext()) {
                    eventsInWindow.add(it.next());
                }
                EventBean[] newEvents = eventsInWindow.toArray(new EventBean[0]);
                ((View)viewableRoot).update(newEvents, null);
                eventIndex.add(newEvents);
            } else {
                Iterator<EventBean> it = subselectView.iterator();
                if (it != null && it.hasNext()) {
                    ArrayList<EventBean> preloadEvents = new ArrayList<EventBean>();
                    while (it.hasNext()) {
                        preloadEvents.add(it.next());
                    }
                    eventIndex.add(preloadEvents.toArray(new EventBean[0]));
                }
            }
            BufferView bufferView = new BufferView(subselectStreamNumber);
            bufferView.setObserver(new BufferObserver(){

                public void newData(int streamId, FlushedEventBuffer newEventBuffer, FlushedEventBuffer oldEventBuffer) {
                    eventIndex.add(newEventBuffer.getAndFlush());
                    eventIndex.remove(oldEventBuffer.getAndFlush());
                }
            });
            subselectView.addView(bufferView);
        }
    }

    private Pair<EventTable, TableLookupStrategy> determineSubqueryIndex(ExprNode filterExpr, EventType viewableEventType, EventType[] outerEventTypes, StreamTypeService subselectTypeService) throws ExprValidationException {
        if (filterExpr == null) {
            UnindexedEventTable table = new UnindexedEventTable(0);
            FullTableScanLookupStrategy strategy = new FullTableScanLookupStrategy(table);
            return new Pair<EventTable, TableLookupStrategy>(table, strategy);
        }
        QueryGraph queryGraph = new QueryGraph(outerEventTypes.length + 1);
        FilterExprAnalyzer.analyze(filterExpr, queryGraph);
        LinkedHashMap<String, JoinedPropDesc> joinProps = new LinkedHashMap<String, JoinedPropDesc>();
        boolean mustCoerce = false;
        for (int stream = 0; stream < outerEventTypes.length; ++stream) {
            int lookupStream = stream + 1;
            String[] keyPropertiesJoin = queryGraph.getKeyProperties(lookupStream, 0);
            String[] indexPropertiesJoin = queryGraph.getIndexProperties(lookupStream, 0);
            if (keyPropertiesJoin == null || keyPropertiesJoin.length == 0) continue;
            if (keyPropertiesJoin.length != indexPropertiesJoin.length) {
                throw new IllegalStateException("Invalid query key and index property collection for stream " + stream);
            }
            for (int i = 0; i < keyPropertiesJoin.length; ++i) {
                Class indexedPropType;
                Class keyPropType = JavaClassHelper.getBoxedType(subselectTypeService.getEventTypes()[lookupStream].getPropertyType(keyPropertiesJoin[i]));
                Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(subselectTypeService.getEventTypes()[0].getPropertyType(indexPropertiesJoin[i]));
                if (keyPropType != indexedPropType) {
                    coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, keyPropType);
                    mustCoerce = true;
                }
                JoinedPropDesc desc = new JoinedPropDesc(indexPropertiesJoin[i], coercionType, keyPropertiesJoin[i], stream);
                joinProps.put(indexPropertiesJoin[i], desc);
            }
        }
        if (joinProps.size() != 0) {
            String[] indexedProps = joinProps.keySet().toArray(new String[0]);
            int[] keyStreamNums = JoinedPropDesc.getKeyStreamNums(joinProps.values());
            String[] keyProps = JoinedPropDesc.getKeyProperties(joinProps.values());
            if (!mustCoerce) {
                PropertyIndexedEventTable table = new PropertyIndexedEventTable(0, viewableEventType, indexedProps);
                IndexedTableLookupStrategy strategy = new IndexedTableLookupStrategy(outerEventTypes, keyStreamNums, keyProps, table);
                return new Pair<EventTable, TableLookupStrategy>(table, strategy);
            }
            Class[] coercionTypes = JoinedPropDesc.getCoercionTypes(joinProps.values());
            PropertyIndTableCoerceAdd table = new PropertyIndTableCoerceAdd(0, viewableEventType, indexedProps, coercionTypes);
            IndexedTableLookupStrategyCoercing strategy = new IndexedTableLookupStrategyCoercing(outerEventTypes, keyStreamNums, keyProps, table, coercionTypes);
            return new Pair<EventTable, TableLookupStrategy>(table, strategy);
        }
        UnindexedEventTable table = new UnindexedEventTable(0);
        return new Pair<EventTable, TableLookupStrategy>(table, new FullTableScanLookupStrategy(table));
    }

    private ExprNode validateJoinNamedWindow(ExprNode deleteJoinExpr, EventType namedWindowType, String namedWindowStreamName, EventType filteredType, String filterStreamName) throws ExprValidationException {
        if (deleteJoinExpr == null) {
            return null;
        }
        LinkedHashMap<String, EventType> namesAndTypes = new LinkedHashMap<String, EventType>();
        namesAndTypes.put(namedWindowStreamName, namedWindowType);
        namesAndTypes.put(filterStreamName, filteredType);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(namesAndTypes, false, false);
        return deleteJoinExpr.getValidatedSubtree(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService());
    }
}

