/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import net.esper.client.ConfigurationEngineDefaults;
import net.esper.core.InsertIntoLatchSpin;
import net.esper.core.InsertIntoLatchWait;

public class InsertIntoLatchFactory {
    private final String name;
    private final boolean useSpin;
    private InsertIntoLatchSpin currentLatchSpin;
    private InsertIntoLatchWait currentLatchWait;
    private long msecWait;

    public InsertIntoLatchFactory(String name, long msecWait, ConfigurationEngineDefaults.Threading.Locking locking) {
        this.name = name;
        this.msecWait = msecWait;
        boolean bl = this.useSpin = locking == ConfigurationEngineDefaults.Threading.Locking.SPIN;
        if (this.useSpin) {
            this.currentLatchSpin = new InsertIntoLatchSpin();
        } else {
            this.currentLatchWait = new InsertIntoLatchWait();
        }
    }

    public Object newLatch(Object payload) {
        if (this.useSpin) {
            InsertIntoLatchSpin nextLatch;
            this.currentLatchSpin = nextLatch = new InsertIntoLatchSpin(this.currentLatchSpin, this.msecWait, payload);
            return nextLatch;
        }
        InsertIntoLatchWait nextLatch = new InsertIntoLatchWait(this.currentLatchWait, this.msecWait, payload);
        this.currentLatchWait.setLater(nextLatch);
        this.currentLatchWait = nextLatch;
        return nextLatch;
    }
}

