/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InsertIntoLatchSpin {
    private static final Log log = LogFactory.getLog(InsertIntoLatchSpin.class);
    private InsertIntoLatchSpin earlier;
    private long msecTimeout;
    private Object payload;
    private volatile boolean isCompleted;

    public InsertIntoLatchSpin(InsertIntoLatchSpin earlier, long msecTimeout, Object payload) {
        this.earlier = earlier;
        this.msecTimeout = msecTimeout;
        this.payload = payload;
    }

    public InsertIntoLatchSpin() {
        this.isCompleted = true;
        this.earlier = null;
        this.msecTimeout = 0L;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public Object await() {
        if (!this.earlier.isCompleted) {
            long spinStartTime = System.currentTimeMillis();
            while (!this.earlier.isCompleted) {
                Thread.yield();
                long spinDelta = System.currentTimeMillis() - spinStartTime;
                if (spinDelta <= this.msecTimeout) continue;
                log.info("Spin wait timeout exceeded in insert-into dispatch");
                break;
            }
        }
        return this.payload;
    }

    public void done() {
        this.isCompleted = true;
        this.earlier = null;
    }
}

