/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import java.util.Map;
import net.esper.client.EPStatementException;
import net.esper.core.EPServicesContext;
import net.esper.core.EPStatementHandle;
import net.esper.core.StatementContext;
import net.esper.core.StatementContextFactory;
import net.esper.eql.core.MethodResolutionServiceImpl;
import net.esper.eql.join.JoinSetComposerFactoryImpl;
import net.esper.eql.spec.CreateWindowDesc;
import net.esper.eql.spec.OnTriggerDesc;
import net.esper.eql.spec.OnTriggerWindowDesc;
import net.esper.eql.spec.PluggableObjectCollection;
import net.esper.pattern.PatternContextFactoryDefault;
import net.esper.pattern.PatternObjectHelper;
import net.esper.pattern.PatternObjectResolutionServiceImpl;
import net.esper.schedule.ScheduleBucket;
import net.esper.util.ManagedLock;
import net.esper.view.StatementStopServiceImpl;
import net.esper.view.ViewEnumHelper;
import net.esper.view.ViewResolutionServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementContextFactoryDefault
implements StatementContextFactory {
    private PluggableObjectCollection viewClasses = new PluggableObjectCollection();
    private PluggableObjectCollection patternObjectClasses;

    public StatementContextFactoryDefault(PluggableObjectCollection viewPlugIns, PluggableObjectCollection plugInPatternObj) {
        this.viewClasses.addObjects(viewPlugIns);
        this.viewClasses.addObjects(ViewEnumHelper.getBuiltinViews());
        this.patternObjectClasses = new PluggableObjectCollection();
        this.patternObjectClasses.addObjects(plugInPatternObj);
        this.patternObjectClasses.addObjects(PatternObjectHelper.getBuiltinPatternObjects());
    }

    @Override
    public StatementContext makeContext(String statementId, String statementName, String expression, boolean hasVariables, EPServicesContext engineServices, Map<String, Object> optAdditionalContext, OnTriggerDesc optOnTriggerDesc, CreateWindowDesc optCreateWindowDesc) {
        ScheduleBucket scheduleBucket = engineServices.getSchedulingService().allocateBucket();
        ManagedLock statementResourceLock = null;
        if (optOnTriggerDesc != null && optOnTriggerDesc instanceof OnTriggerWindowDesc) {
            String windowName = ((OnTriggerWindowDesc)optOnTriggerDesc).getWindowName();
            statementResourceLock = engineServices.getNamedWindowService().getNamedWindowLock(windowName);
            if (statementResourceLock == null) {
                throw new EPStatementException("Named window '" + windowName + "' has not been declared", expression);
            }
        } else if (optCreateWindowDesc != null) {
            statementResourceLock = engineServices.getNamedWindowService().getNamedWindowLock(optCreateWindowDesc.getWindowName());
            if (statementResourceLock == null) {
                statementResourceLock = engineServices.getStatementLockFactory().getStatementLock(statementName, expression);
                engineServices.getNamedWindowService().addNamedWindowLock(optCreateWindowDesc.getWindowName(), statementResourceLock);
            }
        } else {
            statementResourceLock = engineServices.getStatementLockFactory().getStatementLock(statementName, expression);
        }
        EPStatementHandle epStatementHandle = new EPStatementHandle(statementId, statementResourceLock, expression, hasVariables);
        MethodResolutionServiceImpl methodResolutionService = new MethodResolutionServiceImpl(engineServices.getEngineImportService());
        PatternContextFactoryDefault patternContextFactory = new PatternContextFactoryDefault();
        ViewResolutionServiceImpl viewResolutionService = new ViewResolutionServiceImpl(this.viewClasses);
        PatternObjectResolutionServiceImpl patternResolutionService = new PatternObjectResolutionServiceImpl(this.patternObjectClasses);
        return new StatementContext(engineServices.getEngineURI(), engineServices.getEngineInstanceId(), statementId, statementName, expression, engineServices.getSchedulingService(), scheduleBucket, engineServices.getEventAdapterService(), epStatementHandle, viewResolutionService, patternResolutionService, null, new StatementStopServiceImpl(), methodResolutionService, patternContextFactory, engineServices.getFilterService(), new JoinSetComposerFactoryImpl(), engineServices.getOutputConditionFactory(), engineServices.getNamedWindowService(), engineServices.getVariableService());
    }
}

