/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.esper.client.ConfigurationEngineDefaults;
import net.esper.client.EPException;
import net.esper.client.EPServiceProvider;
import net.esper.client.EPStatement;
import net.esper.client.EPStatementException;
import net.esper.client.EPStatementState;
import net.esper.collection.Pair;
import net.esper.core.EPServicesContext;
import net.esper.core.EPStatementHandle;
import net.esper.core.EPStatementImpl;
import net.esper.core.EPStatementListenerSet;
import net.esper.core.EPStatementSPI;
import net.esper.core.EPStatementStartMethod;
import net.esper.core.EPStatementStopMethod;
import net.esper.core.InsertIntoLatchFactory;
import net.esper.core.StatementContext;
import net.esper.core.StatementLifecycleSvc;
import net.esper.eql.core.StreamTypeServiceImpl;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprNodeSubselectVisitor;
import net.esper.eql.expression.ExprSubselectNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.FilterStreamSpecCompiled;
import net.esper.eql.spec.PatternStreamSpecCompiled;
import net.esper.eql.spec.SelectClauseSpec;
import net.esper.eql.spec.SelectExprElementCompiledSpec;
import net.esper.eql.spec.SelectExprElementRawSpec;
import net.esper.eql.spec.StatementSpecCompiled;
import net.esper.eql.spec.StatementSpecRaw;
import net.esper.eql.spec.StreamSpecCompiled;
import net.esper.eql.spec.StreamSpecRaw;
import net.esper.event.EventType;
import net.esper.event.MapEventType;
import net.esper.filter.FilterSpecCompiled;
import net.esper.filter.FilterSpecParam;
import net.esper.pattern.EvalFilterNode;
import net.esper.pattern.EvalNode;
import net.esper.pattern.EvalNodeAnalysisResult;
import net.esper.util.ManagedReadWriteLock;
import net.esper.util.UuidGenerator;
import net.esper.view.ViewProcessingException;
import net.esper.view.Viewable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementLifecycleSvcImpl
implements StatementLifecycleSvc {
    private static Log log = LogFactory.getLog(StatementLifecycleSvcImpl.class);
    protected final EPServicesContext services;
    protected final Map<String, EPStatementDesc> stmtIdToDescMap;
    protected final Map<String, EPStatement> stmtNameToStmtMap;
    private final EPServiceProvider epServiceProvider;
    private final ManagedReadWriteLock eventProcessingRWLock;
    private final Map<String, String> stmtNameToIdMap;

    @Override
    public void destroy() {
        this.destroyAllStatements();
    }

    @Override
    public void init() {
    }

    public StatementLifecycleSvcImpl(EPServiceProvider epServiceProvider, EPServicesContext services) {
        this.services = services;
        this.epServiceProvider = epServiceProvider;
        this.eventProcessingRWLock = services.getEventProcessingRWLock();
        this.stmtIdToDescMap = new HashMap<String, EPStatementDesc>();
        this.stmtNameToStmtMap = new HashMap<String, EPStatement>();
        this.stmtNameToIdMap = new HashMap<String, String>();
    }

    @Override
    public synchronized EPStatement createAndStart(StatementSpecRaw statementSpec, String expression, boolean isPattern, String optStatementName) {
        String statementId = UuidGenerator.generate(expression);
        return this.createAndStart(statementSpec, expression, isPattern, optStatementName, statementId, null);
    }

    protected synchronized EPStatement createAndStart(StatementSpecRaw statementSpec, String expression, boolean isPattern, String optStatementName, String statementId, Map<String, Object> optAdditionalContext) {
        String statementName = statementId;
        if (optStatementName != null) {
            statementName = this.getUniqueStatementName(optStatementName, statementId);
        }
        EPStatementDesc desc = this.createStopped(statementSpec, expression, isPattern, statementName, statementId, optAdditionalContext);
        this.start(statementId, desc, true);
        return desc.getEpStatement();
    }

    protected synchronized EPStatement createStarted(StatementSpecRaw statementSpec, String expression, boolean isPattern, String statementName, String statementId, Map<String, Object> optAdditionalContext) {
        if (log.isDebugEnabled()) {
            log.debug(".start Creating and starting statement " + statementId);
        }
        EPStatementDesc desc = this.createStopped(statementSpec, expression, isPattern, statementName, statementId, optAdditionalContext);
        this.start(statementId, desc, true);
        return desc.getEpStatement();
    }

    protected synchronized EPStatementDesc createStopped(StatementSpecRaw statementSpec, String expression, boolean isPattern, String statementName, String statementId, Map<String, Object> optAdditionalContext) {
        EPStatementDesc statementDesc;
        StatementContext statementContext = this.services.getStatementContextFactory().makeContext(statementId, statementName, expression, statementSpec.isHasVariables(), this.services, optAdditionalContext, statementSpec.getOnTriggerDesc(), statementSpec.getCreateWindowDesc());
        StatementSpecCompiled compiledSpec = null;
        try {
            compiledSpec = StatementLifecycleSvcImpl.compile(statementSpec, expression, statementContext);
        }
        catch (EPStatementException ex) {
            this.stmtNameToIdMap.remove(statementName);
            throw ex;
        }
        if (statementSpec.getInsertIntoDesc() != null) {
            String insertIntoStreamName = statementSpec.getInsertIntoDesc().getEventTypeAlias();
            String latchFactoryName = "insert_stream_" + insertIntoStreamName + "_" + statementId;
            long msecTimeout = this.services.getEngineSettingsService().getEngineSettings().getThreading().getInsertIntoDispatchTimeout();
            ConfigurationEngineDefaults.Threading.Locking locking = this.services.getEngineSettingsService().getEngineSettings().getThreading().getInsertIntoDispatchLocking();
            InsertIntoLatchFactory latchFactory = new InsertIntoLatchFactory(latchFactoryName, msecTimeout, locking);
            statementContext.getEpStatementHandle().setInsertIntoLatchFactory(latchFactory);
        }
        boolean canSelfJoin = this.isPotentialSelfJoin(compiledSpec.getStreamSpecs());
        statementContext.getEpStatementHandle().setCanSelfJoin(canSelfJoin);
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            boolean preserveDispatchOrder = this.services.getEngineSettingsService().getEngineSettings().getThreading().isListenerDispatchPreserveOrder();
            boolean isSpinLocks = this.services.getEngineSettingsService().getEngineSettings().getThreading().getListenerDispatchLocking() == ConfigurationEngineDefaults.Threading.Locking.SPIN;
            long blockingTimeout = this.services.getEngineSettingsService().getEngineSettings().getThreading().getListenerDispatchTimeout();
            long timeLastStateChange = this.services.getSchedulingService().getTime();
            EPStatementImpl statement = new EPStatementImpl(this.epServiceProvider, statementId, statementName, expression, isPattern, this.services.getDispatchService(), this, timeLastStateChange, preserveDispatchOrder, isSpinLocks, blockingTimeout, statementContext.getEpStatementHandle(), statementContext.getVariableService());
            EPStatementStartMethod startMethod = new EPStatementStartMethod(compiledSpec, this.services, statementContext);
            String insertIntoStreamName = null;
            if (statementSpec.getInsertIntoDesc() != null) {
                insertIntoStreamName = statementSpec.getInsertIntoDesc().getEventTypeAlias();
            }
            statementDesc = new EPStatementDesc(statement, startMethod, null, insertIntoStreamName, statementContext.getEpStatementHandle());
            this.stmtIdToDescMap.put(statementId, statementDesc);
            this.stmtNameToStmtMap.put(statementName, statement);
            this.stmtNameToIdMap.put(statementName, statementId);
        }
        catch (RuntimeException ex) {
            this.stmtIdToDescMap.remove(statementId);
            this.stmtNameToIdMap.remove(statementName);
            this.stmtNameToStmtMap.remove(statementName);
            throw ex;
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
        return statementDesc;
    }

    private boolean isPotentialSelfJoin(List<StreamSpecCompiled> streamSpecs) {
        if (streamSpecs.size() == 1) {
            return false;
        }
        ArrayList<EventType> filteredTypes = new ArrayList<EventType>();
        boolean hasFilterStream = false;
        for (StreamSpecCompiled streamSpec : streamSpecs) {
            if (streamSpec instanceof FilterStreamSpecCompiled) {
                EventType type = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().getEventType();
                filteredTypes.add(type);
                hasFilterStream = true;
                continue;
            }
            if (!(streamSpec instanceof PatternStreamSpecCompiled)) continue;
            EvalNodeAnalysisResult evalNodeAnalysisResult = EvalNode.recursiveAnalyzeChildNodes(((PatternStreamSpecCompiled)streamSpec).getEvalNode());
            List<EvalFilterNode> filterNodes = evalNodeAnalysisResult.getFilterNodes();
            for (EvalFilterNode filterNode : filterNodes) {
                filteredTypes.add(filterNode.getFilterSpec().getEventType());
            }
        }
        if (filteredTypes.size() == 1) {
            return false;
        }
        if (!hasFilterStream) {
            return false;
        }
        for (int i = 0; i < filteredTypes.size(); ++i) {
            for (int j = i + 1; j < filteredTypes.size(); ++j) {
                EventType typeTwo;
                EventType typeOne = (EventType)filteredTypes.get(i);
                if (typeOne == (typeTwo = (EventType)filteredTypes.get(j))) {
                    return true;
                }
                if (typeOne.getSuperTypes() != null) {
                    for (EventType typeOneSuper : typeOne.getSuperTypes()) {
                        if (typeOneSuper != typeTwo) continue;
                        return true;
                    }
                }
                if (typeTwo.getSuperTypes() == null) continue;
                for (EventType typeTwoSuper : typeTwo.getSuperTypes()) {
                    if (typeOne != typeTwoSuper) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public synchronized void start(String statementId) {
        if (log.isDebugEnabled()) {
            log.debug(".start Starting statement " + statementId);
        }
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
            if (desc == null) {
                throw new IllegalStateException("Cannot start statement, statement is in destroyed state");
            }
            this.startInternal(statementId, desc, false);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    public void start(String statementId, EPStatementDesc desc, boolean isNewStatement) {
        if (log.isDebugEnabled()) {
            log.debug(".start Starting statement " + statementId + " from desc=" + desc);
        }
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            this.startInternal(statementId, desc, isNewStatement);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    private void startInternal(String statementId, EPStatementDesc desc, boolean isNewStatement) {
        Pair<Viewable, EPStatementStopMethod> pair;
        if (log.isDebugEnabled()) {
            log.debug(".startInternal Starting statement " + statementId + " from desc=" + desc);
        }
        if (desc.getStartMethod() == null) {
            throw new IllegalStateException("Statement start method not found for id " + statementId);
        }
        EPStatementSPI statement = desc.getEpStatement();
        if (statement.getState() == EPStatementState.STARTED) {
            throw new IllegalStateException("Statement already started");
        }
        try {
            pair = desc.getStartMethod().start(isNewStatement);
        }
        catch (ExprValidationException ex) {
            this.stmtIdToDescMap.remove(statementId);
            this.stmtNameToIdMap.remove(statement.getName());
            this.stmtNameToStmtMap.remove(statement.getName());
            log.debug(".start Error starting view", ex);
            throw new EPStatementException("Error starting view: " + ex.getMessage(), statement.getText());
        }
        catch (ViewProcessingException ex) {
            this.stmtIdToDescMap.remove(statementId);
            this.stmtNameToIdMap.remove(statement.getName());
            this.stmtNameToStmtMap.remove(statement.getName());
            log.debug(".start Error starting view", ex);
            throw new EPStatementException("Error starting view: " + ex.getMessage(), statement.getText());
        }
        Viewable parentView = pair.getFirst();
        EPStatementStopMethod stopMethod = pair.getSecond();
        desc.setStopMethod(stopMethod);
        statement.setParentView(parentView);
        long timeLastStateChange = this.services.getSchedulingService().getTime();
        statement.setCurrentState(EPStatementState.STARTED, timeLastStateChange);
    }

    @Override
    public synchronized void stop(String statementId) {
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
            if (desc == null) {
                throw new IllegalStateException("Cannot stop statement, statement is in destroyed state");
            }
            EPStatementSPI statement = desc.getEpStatement();
            EPStatementStopMethod stopMethod = desc.getStopMethod();
            if (stopMethod == null) {
                throw new IllegalStateException("Stop method not found for statement " + statementId);
            }
            if (statement.getState() == EPStatementState.STOPPED) {
                throw new IllegalStateException("Statement already stopped");
            }
            stopMethod.stop();
            statement.setParentView(null);
            desc.setStopMethod(null);
            long timeLastStateChange = this.services.getSchedulingService().getTime();
            statement.setCurrentState(EPStatementState.STOPPED, timeLastStateChange);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    @Override
    public synchronized void destroy(String statementId) {
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
            if (desc == null) {
                throw new IllegalStateException("Statement already destroyed");
            }
            EPStatementSPI statement = desc.getEpStatement();
            if (statement.getState() == EPStatementState.STARTED) {
                EPStatementStopMethod stopMethod = desc.getStopMethod();
                statement.setParentView(null);
                stopMethod.stop();
            }
            long timeLastStateChange = this.services.getSchedulingService().getTime();
            statement.setCurrentState(EPStatementState.DESTROYED, timeLastStateChange);
            this.stmtNameToStmtMap.remove(statement.getName());
            this.stmtNameToIdMap.remove(statement.getName());
            this.stmtIdToDescMap.remove(statementId);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    @Override
    public synchronized EPStatement getStatementByName(String name) {
        return this.stmtNameToStmtMap.get(name);
    }

    public EPStatementSPI getStatementById(String id) {
        return this.stmtIdToDescMap.get(id).getEpStatement();
    }

    @Override
    public synchronized String[] getStatementNames() {
        String[] statements = new String[this.stmtNameToStmtMap.size()];
        int count = 0;
        for (String key : this.stmtNameToStmtMap.keySet()) {
            statements[count++] = key;
        }
        return statements;
    }

    @Override
    public synchronized void startAllStatements() throws EPException {
        String[] statementIds = this.getStatementIds();
        for (int i = 0; i < statementIds.length; ++i) {
            EPStatementSPI statement = this.stmtIdToDescMap.get(statementIds[i]).getEpStatement();
            if (statement.getState() != EPStatementState.STOPPED) continue;
            this.start(statementIds[i]);
        }
    }

    @Override
    public synchronized void stopAllStatements() throws EPException {
        String[] statementIds = this.getStatementIds();
        for (int i = 0; i < statementIds.length; ++i) {
            EPStatementSPI statement = this.stmtIdToDescMap.get(statementIds[i]).getEpStatement();
            if (statement.getState() != EPStatementState.STARTED) continue;
            this.stop(statementIds[i]);
        }
    }

    @Override
    public synchronized void destroyAllStatements() throws EPException {
        String[] statementIds = this.getStatementIds();
        for (int i = 0; i < statementIds.length; ++i) {
            this.destroy(statementIds[i]);
        }
    }

    private String[] getStatementIds() {
        String[] statementIds = new String[this.stmtNameToIdMap.size()];
        int count = 0;
        for (String id : this.stmtNameToIdMap.values()) {
            statementIds[count++] = id;
        }
        return statementIds;
    }

    private String getUniqueStatementName(String statementName, String statementId) {
        String finalStatementName;
        if (this.stmtNameToIdMap.containsKey(statementName)) {
            int count = 0;
            while (this.stmtNameToIdMap.containsKey(finalStatementName = statementName + "--" + count)) {
                if (count > 0x7FFFFFFD) {
                    throw new EPException("Failed to establish a unique statement name");
                }
                ++count;
            }
        } else {
            finalStatementName = statementName;
        }
        this.stmtNameToIdMap.put(finalStatementName, statementId);
        return finalStatementName;
    }

    @Override
    public void updatedListeners(String statementId, String statementName, EPStatementListenerSet listeners) {
        log.debug(".updatedListeners No action for base implementation");
    }

    private static StatementSpecCompiled compile(StatementSpecRaw spec, String eqlStatement, StatementContext statementContext) throws EPStatementException {
        ArrayList<StreamSpecCompiled> compiledStreams;
        try {
            compiledStreams = new ArrayList<StreamSpecCompiled>();
            for (StreamSpecRaw rawSpec : spec.getStreamSpecs()) {
                StreamSpecCompiled compiled = rawSpec.compile(statementContext.getEventAdapterService(), statementContext.getMethodResolutionService(), statementContext.getPatternResolutionService(), statementContext.getSchedulingService(), statementContext.getNamedWindowService(), statementContext.getVariableService());
                compiledStreams.add(compiled);
            }
        }
        catch (ExprValidationException ex) {
            throw new EPStatementException(ex.getMessage(), eqlStatement);
        }
        catch (RuntimeException ex) {
            String text = "Unexpected error compiling statement";
            log.error(".compile " + text, ex);
            throw new EPStatementException(text + ":" + ex.getClass().getName() + ":" + ex.getMessage(), eqlStatement);
        }
        if (spec.getCreateWindowDesc() != null) {
            try {
                FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)compiledStreams.get(0);
                EventType selectFromType = filterStreamSpec.getFilterSpec().getEventType();
                FilterSpecCompiled newFilter = StatementLifecycleSvcImpl.handleCreateWindow(selectFromType, spec, eqlStatement, statementContext);
                filterStreamSpec.setFilterSpec(newFilter);
                if (spec.getCreateWindowDesc().getViewSpecs().isEmpty()) {
                    throw new ExprValidationException("Named windows require one or more child views that are data window views");
                }
                filterStreamSpec.getViewSpecs().addAll(spec.getCreateWindowDesc().getViewSpecs());
                spec.getSelectClauseSpec().getSelectExprList().clear();
            }
            catch (ExprValidationException e) {
                throw new EPStatementException(e.getMessage(), eqlStatement);
            }
        }
        ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
        for (SelectExprElementRawSpec raw : spec.getSelectClauseSpec().getSelectExprList()) {
            raw.getSelectExpression().accept(visitor);
        }
        if (spec.getFilterRootNode() != null) {
            spec.getFilterRootNode().accept(visitor);
        }
        for (ExprSubselectNode subselect : visitor.getSubselects()) {
            StatementSpecRaw raw = subselect.getStatementSpecRaw();
            StatementSpecCompiled compiled = StatementLifecycleSvcImpl.compile(raw, eqlStatement, statementContext);
            subselect.setStatementSpecCompiled(compiled);
        }
        return new StatementSpecCompiled(spec.getOnTriggerDesc(), spec.getCreateWindowDesc(), spec.getCreateVariableDesc(), spec.getInsertIntoDesc(), spec.getSelectStreamSelectorEnum(), spec.getSelectClauseSpec(), compiledStreams, spec.getOuterJoinDescList(), spec.getFilterRootNode(), spec.getGroupByExpressions(), spec.getHavingExprRootNode(), spec.getOutputLimitSpec(), spec.getOrderByList(), visitor.getSubselects(), spec.isHasVariables());
    }

    private static FilterSpecCompiled handleCreateWindow(EventType selectFromType, StatementSpecRaw spec, String eqlStatement, StatementContext statementContext) throws ExprValidationException {
        String typeName = spec.getCreateWindowDesc().getWindowName();
        EventType targetType = null;
        List<SelectExprElementCompiledSpec> select = StatementLifecycleSvcImpl.compileLimitedSelect(spec.getSelectClauseSpec(), eqlStatement, selectFromType);
        HashMap<String, Class> properties = new HashMap<String, Class>();
        for (SelectExprElementCompiledSpec selectElement : select) {
            properties.put(selectElement.getAssignedName(), selectElement.getSelectExpression().getType());
        }
        boolean isWildcard = spec.getSelectClauseSpec().isUsingWildcard();
        if (isWildcard) {
            targetType = statementContext.getEventAdapterService().addWrapperType(typeName, selectFromType, properties);
        } else if (spec.getSelectClauseSpec().getSelectExprList().size() > 0) {
            targetType = statementContext.getEventAdapterService().addMapType(typeName, properties);
        } else if (selectFromType instanceof MapEventType) {
            MapEventType mapType = (MapEventType)selectFromType;
            targetType = statementContext.getEventAdapterService().addMapType(typeName, mapType.getTypes());
        } else {
            HashMap<String, Class> addOnTypes = new HashMap<String, Class>();
            targetType = statementContext.getEventAdapterService().addWrapperType(typeName, selectFromType, addOnTypes);
        }
        return new FilterSpecCompiled(targetType, new ArrayList<FilterSpecParam>());
    }

    private static List<SelectExprElementCompiledSpec> compileLimitedSelect(SelectClauseSpec spec, String eqlStatement, EventType singleType) {
        LinkedList<SelectExprElementCompiledSpec> selectProps = new LinkedList<SelectExprElementCompiledSpec>();
        StreamTypeServiceImpl streams = new StreamTypeServiceImpl(new EventType[]{singleType}, new String[]{"stream_0"});
        for (SelectExprElementRawSpec raw : spec.getSelectExprList()) {
            ExprNode validatedExpression = null;
            try {
                validatedExpression = raw.getSelectExpression().getValidatedSubtree(streams, null, null, null, null);
            }
            catch (ExprValidationException e) {
                throw new EPStatementException(e.getMessage(), eqlStatement);
            }
            String asName = raw.getOptionalAsName();
            if (asName == null) {
                asName = validatedExpression.toExpressionString();
            }
            SelectExprElementCompiledSpec validatedElement = new SelectExprElementCompiledSpec(validatedExpression, asName);
            selectProps.add(validatedElement);
        }
        return selectProps;
    }

    public class EPStatementDesc {
        private EPStatementSPI epStatement;
        private EPStatementStartMethod startMethod;
        private EPStatementStopMethod stopMethod;
        private String optInsertIntoStream;
        private EPStatementHandle statementHandle;

        public EPStatementDesc(EPStatementSPI epStatement, EPStatementStartMethod startMethod, EPStatementStopMethod stopMethod, String optInsertIntoStream, EPStatementHandle statementHandle) {
            this.epStatement = epStatement;
            this.startMethod = startMethod;
            this.stopMethod = stopMethod;
            this.optInsertIntoStream = optInsertIntoStream;
            this.statementHandle = statementHandle;
        }

        public EPStatementSPI getEpStatement() {
            return this.epStatement;
        }

        public EPStatementStartMethod getStartMethod() {
            return this.startMethod;
        }

        public EPStatementStopMethod getStopMethod() {
            return this.stopMethod;
        }

        public String getOptInsertIntoStream() {
            return this.optInsertIntoStream;
        }

        public void setStopMethod(EPStatementStopMethod stopMethod) {
            this.stopMethod = stopMethod;
        }

        public EPStatementHandle getStatementHandle() {
            return this.statementHandle;
        }
    }
}

