/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import net.esper.core.UpdateDispatchViewBlockingSpin;
import net.esper.dispatch.Dispatchable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateDispatchFutureSpin
implements Dispatchable {
    private static final Log log = LogFactory.getLog(UpdateDispatchFutureSpin.class);
    private UpdateDispatchViewBlockingSpin view;
    private UpdateDispatchFutureSpin earlier;
    private volatile boolean isCompleted;
    private long msecTimeout;

    public UpdateDispatchFutureSpin(UpdateDispatchViewBlockingSpin view, UpdateDispatchFutureSpin earlier, long msecTimeout) {
        this.view = view;
        this.earlier = earlier;
        this.msecTimeout = msecTimeout;
    }

    public UpdateDispatchFutureSpin() {
        this.isCompleted = true;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void execute() {
        if (!this.earlier.isCompleted) {
            long spinStartTime = System.currentTimeMillis();
            while (!this.earlier.isCompleted) {
                Thread.yield();
                long spinDelta = System.currentTimeMillis() - spinStartTime;
                if (spinDelta <= this.msecTimeout) continue;
                log.info("Spin wait timeout exceeded in listener dispatch");
                break;
            }
        }
        this.view.execute();
        this.isCompleted = true;
        this.earlier = null;
    }
}

