/*
 * Decompiled with CFR 0.152.
 */
package net.esper.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.esper.client.EPServiceProvider;
import net.esper.client.EPStatement;
import net.esper.client.StatementAwareUpdateListener;
import net.esper.client.UpdateListener;
import net.esper.collection.SingleEventIterator;
import net.esper.core.EPStatementListenerSet;
import net.esper.dispatch.DispatchService;
import net.esper.dispatch.Dispatchable;
import net.esper.event.EventBean;
import net.esper.event.EventBeanUtility;
import net.esper.event.EventType;
import net.esper.view.ViewSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdateDispatchViewBase
extends ViewSupport
implements Dispatchable {
    private final EPServiceProvider epServiceProvider;
    private final EPStatement statement;
    private EPStatementListenerSet statementListenerSet;
    protected final DispatchService dispatchService;
    protected EventBean lastIterableEvent;
    protected ThreadLocal<Boolean> isDispatchWaiting = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    protected ThreadLocal<LinkedList<EventBean[]>> lastNewEvents = new ThreadLocal<LinkedList<EventBean[]>>(){

        @Override
        protected synchronized LinkedList<EventBean[]> initialValue() {
            return new LinkedList<EventBean[]>();
        }
    };
    protected ThreadLocal<LinkedList<EventBean[]>> lastOldEvents = new ThreadLocal<LinkedList<EventBean[]>>(){

        @Override
        protected synchronized LinkedList<EventBean[]> initialValue() {
            return new LinkedList<EventBean[]>();
        }
    };
    private static Log log = LogFactory.getLog(UpdateDispatchViewBase.class);

    public UpdateDispatchViewBase(EPServiceProvider epServiceProvider, EPStatement statement, EPStatementListenerSet updateListeners, DispatchService dispatchService) {
        this.epServiceProvider = epServiceProvider;
        this.statement = statement;
        this.statementListenerSet = updateListeners;
        this.dispatchService = dispatchService;
    }

    public void setUpdateListeners(EPStatementListenerSet updateListeners) {
        this.statementListenerSet = updateListeners;
    }

    @Override
    public EventType getEventType() {
        return null;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.lastIterableEvent);
    }

    public void dispatchOnStop() {
        if (this.lastNewEvents.get().size() > 0 || this.lastOldEvents.get().size() > 0) {
            this.execute();
        }
    }

    @Override
    public void execute() {
        this.isDispatchWaiting.set(false);
        Object[] newEvents = EventBeanUtility.flatten((List<EventBean[]>)this.lastNewEvents.get());
        Object[] oldEvents = EventBeanUtility.flatten((List<EventBean[]>)this.lastOldEvents.get());
        if (log.isDebugEnabled()) {
            ViewSupport.dumpUpdateParams(".execute", newEvents, oldEvents);
        }
        for (UpdateListener updateListener : this.statementListenerSet.listeners) {
            updateListener.update((EventBean[])newEvents, (EventBean[])oldEvents);
        }
        if (!this.statementListenerSet.stmtAwareListeners.isEmpty()) {
            for (StatementAwareUpdateListener statementAwareUpdateListener : this.statementListenerSet.getStmtAwareListeners()) {
                statementAwareUpdateListener.update((EventBean[])newEvents, (EventBean[])oldEvents, this.statement, this.epServiceProvider);
            }
        }
        this.lastNewEvents.get().clear();
        this.lastOldEvents.get().clear();
    }

    public void clear() {
        this.lastIterableEvent = null;
    }
}

