/*
 * Decompiled with CFR 0.152.
 */
package net.esper.dispatch;

import java.util.LinkedList;
import net.esper.dispatch.DispatchService;
import net.esper.dispatch.Dispatchable;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchServiceImpl
implements DispatchService {
    private static final ThreadLocal<LinkedList<Dispatchable>> threadDispatchQueue = new ThreadLocal<LinkedList<Dispatchable>>(){

        @Override
        protected synchronized LinkedList<Dispatchable> initialValue() {
            return new LinkedList<Dispatchable>();
        }
    };
    private static final Log log = LogFactory.getLog(DispatchServiceImpl.class);

    @Override
    public void dispatch() {
        DispatchServiceImpl.dispatchFromQueue(threadDispatchQueue.get());
    }

    @Override
    public void addExternal(Dispatchable dispatchable) {
        LinkedList<Dispatchable> dispatchQueue = threadDispatchQueue.get();
        DispatchServiceImpl.addToQueue(dispatchable, dispatchQueue);
    }

    private static void addToQueue(Dispatchable dispatchable, LinkedList<Dispatchable> dispatchQueue) {
        dispatchQueue.add(dispatchable);
    }

    private static void dispatchFromQueue(LinkedList<Dispatchable> dispatchQueue) {
        Dispatchable next;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".dispatchFromQueue Dispatch queue is " + dispatchQueue.size() + " elements");
        }
        while ((next = dispatchQueue.poll()) != null) {
            next.execute();
        }
    }
}

