/*
 * Decompiled with CFR 0.152.
 */
package net.esper.emit;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.esper.client.EmittedListener;
import net.esper.emit.EmitService;

public final class EmitServiceImpl
implements EmitService {
    private final HashMap<String, List<EmittedListener>> channelEmitListeners = new HashMap();
    private final ReadWriteLock channelEmitListenersRWLock = new ReentrantReadWriteLock();
    private final AtomicInteger numEventsEmitted = new AtomicInteger();

    protected EmitServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(EmittedListener listener, String channel) {
        this.channelEmitListenersRWLock.writeLock().lock();
        try {
            for (Map.Entry<String, List<EmittedListener>> entry : this.channelEmitListeners.entrySet()) {
                if (!entry.getValue().contains(listener)) continue;
                if (entry.getKey() == null || channel != null && channel.equals(entry.getKey())) {
                    return;
                }
                if (channel != null) continue;
                entry.getValue().remove(listener);
            }
            List<EmittedListener> listeners = this.channelEmitListeners.get(channel);
            if (listeners == null) {
                listeners = new LinkedList<EmittedListener>();
                this.channelEmitListeners.put(channel, listeners);
            }
            listeners.add(listener);
        }
        finally {
            this.channelEmitListenersRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearListeners() {
        this.channelEmitListenersRWLock.writeLock().lock();
        try {
            this.channelEmitListeners.clear();
        }
        finally {
            this.channelEmitListenersRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void emitEvent(Object object, String channel) {
        this.channelEmitListenersRWLock.readLock().lock();
        try {
            List<EmittedListener> listeners;
            if (channel != null && (listeners = this.channelEmitListeners.get(channel)) != null) {
                for (EmittedListener listener : listeners) {
                    listener.emitted(object);
                }
            }
            if ((listeners = this.channelEmitListeners.get(null)) != null) {
                for (EmittedListener listener : listeners) {
                    listener.emitted(object);
                }
            }
        }
        finally {
            this.channelEmitListenersRWLock.readLock().unlock();
        }
        this.numEventsEmitted.incrementAndGet();
    }

    public final int getNumEventsEmitted() {
        return this.numEventsEmitted.get();
    }
}

