/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.agg;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.agg.AggregationService;
import net.esper.eql.agg.AggregationServiceBase;
import net.esper.eql.agg.AggregationServiceGroupAllImpl;
import net.esper.eql.agg.AggregationServiceGroupByImpl;
import net.esper.eql.agg.AggregationServiceNull;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.expression.ExprAggregateNode;
import net.esper.eql.expression.ExprEvaluator;
import net.esper.eql.expression.ExprNode;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationServiceFactory {
    public static AggregationService getService(List<ExprAggregateNode> selectAggregateExprNodes, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes, boolean hasGroupByClause, MethodResolutionService methodResolutionService) {
        if (selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            return new AggregationServiceNull();
        }
        LinkedHashMap<ExprAggregateNode, List<ExprAggregateNode>> equivalencyList = new LinkedHashMap<ExprAggregateNode, List<ExprAggregateNode>>();
        for (ExprAggregateNode selectAggNode : selectAggregateExprNodes) {
            AggregationServiceFactory.addEquivalent(selectAggNode, equivalencyList);
        }
        for (ExprAggregateNode havingAggNode : havingAggregateExprNodes) {
            AggregationServiceFactory.addEquivalent(havingAggNode, equivalencyList);
        }
        for (ExprAggregateNode orderByAggNode : orderByAggregateExprNodes) {
            AggregationServiceFactory.addEquivalent(orderByAggNode, equivalencyList);
        }
        AggregationMethod[] aggregators = new AggregationMethod[equivalencyList.size()];
        ExprEvaluator[] evaluators = new ExprEvaluator[equivalencyList.size()];
        int index = 0;
        for (ExprAggregateNode aggregateNode : equivalencyList.keySet()) {
            if (aggregateNode.getChildNodes().size() > 1) {
                throw new IllegalStateException("Aggregate node is expected to have at most a single child node");
            }
            evaluators[index] = !aggregateNode.getChildNodes().isEmpty() ? (ExprEvaluator)aggregateNode.getChildNodes().get(0) : new ExprEvaluator(){

                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
                    return null;
                }
            };
            aggregators[index] = aggregateNode.getPrototypeAggregator();
            ++index;
        }
        AggregationServiceBase service = hasGroupByClause ? new AggregationServiceGroupByImpl(evaluators, aggregators, methodResolutionService) : new AggregationServiceGroupAllImpl(evaluators, aggregators);
        int column = 0;
        for (ExprAggregateNode aggregateNode : equivalencyList.keySet()) {
            aggregateNode.setAggregationResultFuture(service, column);
            List equivalentAggregators = (List)equivalencyList.get(aggregateNode);
            if (equivalentAggregators != null) {
                for (ExprAggregateNode equivalentAggNode : equivalentAggregators) {
                    equivalentAggNode.setAggregationResultFuture(service, column);
                }
            }
            ++column;
        }
        return service;
    }

    private static void addEquivalent(ExprAggregateNode aggNodeToAdd, Map<ExprAggregateNode, List<ExprAggregateNode>> equivalencyList) {
        boolean foundEquivalent = false;
        for (Map.Entry<ExprAggregateNode, List<ExprAggregateNode>> entry : equivalencyList.entrySet()) {
            ExprAggregateNode aggNode = entry.getKey();
            if (!ExprNode.deepEquals(aggNode, aggNodeToAdd)) continue;
            List<ExprAggregateNode> equivalentAggregators = entry.getValue();
            if (equivalentAggregators == null) {
                equivalentAggregators = new ArrayList<ExprAggregateNode>();
            }
            equivalentAggregators.add(aggNodeToAdd);
            equivalencyList.put(aggNode, equivalentAggregators);
            foundEquivalent = true;
            break;
        }
        if (!foundEquivalent) {
            equivalencyList.put(aggNodeToAdd, null);
        }
    }
}

