/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.agg;

import java.util.HashMap;
import java.util.Map;
import net.esper.collection.MultiKeyUntyped;
import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.agg.AggregationServiceBase;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.expression.ExprEvaluator;
import net.esper.event.EventBean;

public class AggregationServiceGroupByImpl
extends AggregationServiceBase {
    private Map<MultiKeyUntyped, AggregationMethod[]> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorRow;
    private MethodResolutionService methodResolutionService;

    public AggregationServiceGroupByImpl(ExprEvaluator[] evaluators, AggregationMethod[] prototypes, MethodResolutionService methodResolutionService) {
        super(evaluators, prototypes);
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<MultiKeyUntyped, AggregationMethod[]>();
    }

    public void clearResults() {
        this.aggregatorsPerGroup.clear();
    }

    public void applyEnter(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey) {
        AggregationMethod[] groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, groupByKey);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true);
            groupAggregators[j].enter(columnResult);
        }
    }

    public void applyLeave(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey) {
        AggregationMethod[] groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, groupByKey);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false);
            groupAggregators[j].leave(columnResult);
        }
    }

    public void setCurrentRow(MultiKeyUntyped groupByKey) {
        this.currentAggregatorRow = this.aggregatorsPerGroup.get(groupByKey);
        if (this.currentAggregatorRow == null) {
            this.currentAggregatorRow = this.methodResolutionService.newAggregators(this.aggregators, groupByKey);
            this.aggregatorsPerGroup.put(groupByKey, this.currentAggregatorRow);
        }
    }

    public Object getValue(int column) {
        return this.currentAggregatorRow[column].getValue();
    }
}

