/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.agg;

import java.util.Iterator;
import java.util.Map;
import net.esper.collection.RefCountedSet;
import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.core.MethodResolutionService;

public class AvedevAggregator
implements AggregationMethod {
    private RefCountedSet<Double> valueSet = new RefCountedSet();
    private double sum;

    public void clear() {
        this.sum = 0.0;
        this.valueSet.clear();
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.valueSet.add(value);
        this.sum += value;
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.valueSet.remove(value);
        this.sum -= value;
    }

    public Object getValue() {
        int datapoints = this.valueSet.size();
        if (datapoints == 0) {
            return null;
        }
        double total = 0.0;
        double avg = this.sum / (double)datapoints;
        Iterator<Map.Entry<Double, Integer>> it = this.valueSet.entryIterator();
        while (it.hasNext()) {
            Map.Entry<Double, Integer> entry = it.next();
            total += (double)entry.getValue().intValue() * Math.abs(entry.getKey() - avg);
        }
        return total / (double)datapoints;
    }

    public Class getValueType() {
        return Double.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeAvedevAggregator();
    }
}

