/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.agg;

import net.esper.collection.RefCountedSet;
import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.core.MethodResolutionService;

public class DistinctValueAggregator
implements AggregationMethod {
    private final AggregationMethod inner;
    private final Class childType;
    private final RefCountedSet<Object> valueSet;

    public DistinctValueAggregator(AggregationMethod inner, Class childType) {
        this.inner = inner;
        this.childType = childType;
        this.valueSet = new RefCountedSet();
    }

    public void clear() {
        this.valueSet.clear();
    }

    public void enter(Object value) {
        if (this.valueSet.add(value)) {
            this.inner.enter(value);
        }
    }

    public void leave(Object value) {
        if (this.valueSet.remove(value)) {
            this.inner.leave(value);
        }
    }

    public Object getValue() {
        return this.inner.getValue();
    }

    public Class getValueType() {
        return this.inner.getValueType();
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        AggregationMethod innerCopy = this.inner.newAggregator(methodResolutionService);
        return methodResolutionService.makeDistinctAggregator(innerCopy, this.childType);
    }
}

