/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.agg;

import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.core.MethodResolutionService;

public class DoubleSumAggregator
implements AggregationMethod {
    private double sum;
    private long numDataPoints;

    public void clear() {
        this.sum = 0.0;
        this.numDataPoints = 0L;
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        this.sum += ((Double)object).doubleValue();
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        --this.numDataPoints;
        this.sum -= ((Double)object).doubleValue();
    }

    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        return this.sum;
    }

    public Class getValueType() {
        return Double.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeSumAggregator(Double.class);
    }
}

