/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.agg;

import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.core.MethodResolutionService;

public class IntegerSumAggregator
implements AggregationMethod {
    private int sum;
    private long numDataPoints;

    public void clear() {
        this.sum = 0;
        this.numDataPoints = 0L;
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        this.sum += ((Integer)object).intValue();
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        --this.numDataPoints;
        this.sum -= ((Integer)object).intValue();
    }

    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        return this.sum;
    }

    public Class getValueType() {
        return Integer.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeSumAggregator(Integer.class);
    }
}

