/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.agg;

import net.esper.collection.SortedDoubleVector;
import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.core.MethodResolutionService;

public class MedianAggregator
implements AggregationMethod {
    private SortedDoubleVector vector = new SortedDoubleVector();

    public void clear() {
        this.vector.clear();
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.vector.add(value);
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.vector.remove(value);
    }

    public Object getValue() {
        if (this.vector.size() == 0) {
            return null;
        }
        if (this.vector.size() == 1) {
            return this.vector.getValue(0);
        }
        int middle = this.vector.size() >> 1;
        if (this.vector.size() % 2 == 0) {
            return (this.vector.getValue(middle - 1) + this.vector.getValue(middle)) / 2.0;
        }
        return this.vector.getValue(middle);
    }

    public Class getValueType() {
        return Double.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeMedianAggregator();
    }
}

