/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.LinkedList;
import java.util.ListIterator;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprNode;

public class AliasNodeSwapper {
    public static ExprNode swap(ExprNode exprTree, String alias, ExprNode fullExpr) {
        if (fullExpr == null) {
            throw new NullPointerException();
        }
        if (AliasNodeSwapper.isAliasNode(exprTree, alias)) {
            return fullExpr;
        }
        AliasNodeSwapper.visitChildren(exprTree, alias, fullExpr);
        return exprTree;
    }

    private static void visitChildren(ExprNode node, String alias, ExprNode fullExpr) {
        LinkedList<ExprNode> childNodes = node.getChildNodes();
        ListIterator<ExprNode> itor = childNodes.listIterator();
        while (itor.hasNext()) {
            ExprNode childNode = (ExprNode)itor.next();
            if (AliasNodeSwapper.isAliasNode(childNode, alias)) {
                itor.set(fullExpr);
                continue;
            }
            AliasNodeSwapper.visitChildren(childNode, alias, fullExpr);
        }
    }

    private static boolean isAliasNode(ExprNode node, String alias) {
        if (node instanceof ExprIdentNode) {
            if (!node.getChildNodes().isEmpty()) {
                throw new IllegalStateException("Ident node has unexpected child nodes");
            }
            return ((ExprIdentNode)node).getUnresolvedPropertyName().equals(alias);
        }
        return false;
    }
}

