/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.esper.client.ConfigurationMethodRef;
import net.esper.eql.agg.AggregationSupport;
import net.esper.eql.core.EngineImportException;
import net.esper.eql.core.EngineImportService;
import net.esper.eql.core.EngineImportUndefinedException;
import net.esper.util.MethodResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineImportServiceImpl
implements EngineImportService {
    private static final Log log = LogFactory.getLog(EngineImportServiceImpl.class);
    private final List<String> imports = new ArrayList<String>();
    private final Map<String, String> aggregationFunctions = new HashMap<String, String>();
    private final Map<String, ConfigurationMethodRef> methodInvocationRef = new HashMap<String, ConfigurationMethodRef>();

    @Override
    public ConfigurationMethodRef getConfigurationMethodRef(String className) {
        return this.methodInvocationRef.get(className);
    }

    public void addMethodRefs(Map<String, ConfigurationMethodRef> configs) {
        this.methodInvocationRef.putAll(configs);
    }

    @Override
    public void addImport(String importName) throws EngineImportException {
        if (!EngineImportServiceImpl.isClassName(importName) && !EngineImportServiceImpl.isPackageName(importName)) {
            throw new EngineImportException("Invalid import name '" + importName + "'");
        }
        this.imports.add(importName);
    }

    @Override
    public void addAggregation(String functionName, String aggregationClass) throws EngineImportException {
        String existing = this.aggregationFunctions.get(functionName);
        if (existing != null) {
            throw new EngineImportException("Aggregation function by name '" + functionName + "' is already defined");
        }
        if (!EngineImportServiceImpl.isFunctionName(functionName)) {
            throw new EngineImportException("Invalid aggregation function name '" + functionName + "'");
        }
        if (!EngineImportServiceImpl.isClassName(aggregationClass)) {
            throw new EngineImportException("Invalid class name for aggregation '" + aggregationClass + "'");
        }
        this.aggregationFunctions.put(functionName.toLowerCase(), aggregationClass);
    }

    @Override
    public AggregationSupport resolveAggregation(String name) throws EngineImportException, EngineImportUndefinedException {
        Class<?> clazz;
        String className = this.aggregationFunctions.get(name);
        if (className == null) {
            className = this.aggregationFunctions.get(name.toLowerCase());
        }
        if (className == null) {
            throw new EngineImportUndefinedException("Aggregation function named '" + name + "' is not defined");
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new EngineImportException("Could not load aggregation class by name '" + className + "'", ex);
        }
        Object object = null;
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new EngineImportException("Error instantiating aggregation class by name '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new EngineImportException("Illegal access instatiating aggregation class by name '" + className + "'", e);
        }
        if (!(object instanceof AggregationSupport)) {
            throw new EngineImportException("Aggregation class by name '" + className + "' does not subclass AggregationSupport");
        }
        return object;
    }

    @Override
    public Method resolveMethod(String classNameAlias, String methodName, Class[] paramTypes) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(classNameAlias);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load class by name '" + classNameAlias + "' ", e);
        }
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, false);
        }
        catch (NoSuchMethodException e) {
            throw new EngineImportException("Could not find static method named '" + methodName + "' in class '" + classNameAlias + "' ", e);
        }
    }

    @Override
    public Method resolveMethod(String classNameAlias, String methodName) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(classNameAlias);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load class by name '" + classNameAlias + "' ", e);
        }
        Method[] methods = clazz.getMethods();
        Method methodByName = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            if (methodByName != null) {
                throw new EngineImportException("Ambiguous method name: method by name '" + methodName + "' is overloaded in class '" + classNameAlias + "'");
            }
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            methodByName = method;
        }
        if (methodByName == null) {
            throw new EngineImportException("Could not find static method named '" + methodName + "' in class '" + classNameAlias + "'");
        }
        return methodByName;
    }

    @Override
    public Class resolveClass(String classNameAlias) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(classNameAlias);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load class by name '" + classNameAlias + "' ", e);
        }
        return clazz;
    }

    protected Class resolveClassInternal(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("Class not found for resolving from name as-is:" + className);
            }
            for (String importName : this.imports) {
                boolean isClassName = EngineImportServiceImpl.isClassName(importName);
                if (isClassName) {
                    if (!importName.endsWith(className)) continue;
                    return Class.forName(importName);
                }
                String prefixedClassName = EngineImportServiceImpl.getPackageName(importName) + '.' + className;
                try {
                    return Class.forName(prefixedClassName);
                }
                catch (ClassNotFoundException e2) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Class not found for resolving from name as-is:" + className);
                }
            }
            throw new ClassNotFoundException("Unknown class " + className);
        }
    }

    @Override
    public Method resolveMethod(Class clazz, String methodName, Class[] paramTypes) throws EngineImportException {
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, true);
        }
        catch (NoSuchMethodException e) {
            throw new EngineImportException("Could not find a method named '" + methodName + "' in class '" + clazz.getName() + "' and matching the required parameter types", e);
        }
    }

    protected String[] getImports() {
        return this.imports.toArray(new String[0]);
    }

    private static boolean isFunctionName(String functionName) {
        String classNameRegEx = "\\w+";
        return functionName.matches(classNameRegEx);
    }

    private static boolean isClassName(String importName) {
        String classNameRegEx = "(\\w+\\.)*\\w+";
        return importName.matches(classNameRegEx);
    }

    private static boolean isPackageName(String importName) {
        String classNameRegEx = "(\\w+\\.)+\\*";
        return importName.matches(classNameRegEx);
    }

    private static String getPackageName(String importName) {
        return importName.substring(0, importName.length() - 2);
    }
}

