/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.esper.client.EPException;
import net.esper.eql.db.PollExecStrategy;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPollingExecStrategy
implements PollExecStrategy {
    private static final Log log = LogFactory.getLog(MethodPollingExecStrategy.class);
    private final EventAdapterService eventAdapterService;
    private final FastMethod method;
    private boolean isArray;

    public MethodPollingExecStrategy(EventAdapterService eventAdapterService, FastMethod method) {
        this.eventAdapterService = eventAdapterService;
        this.method = method;
        this.isArray = method.getReturnType().isArray();
    }

    @Override
    public void start() {
    }

    @Override
    public void done() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public List<EventBean> poll(Object[] lookupValues) {
        AbstractList rowResult = null;
        try {
            Object invocationResult = this.method.invoke(null, lookupValues);
            if (invocationResult != null) {
                if (this.isArray) {
                    int length = Array.getLength(invocationResult);
                    if (length > 0) {
                        rowResult = new ArrayList();
                        for (int i = 0; i < length; ++i) {
                            EventBean event = this.eventAdapterService.adapterForBean(Array.get(invocationResult, i));
                            rowResult.add(event);
                        }
                    }
                } else {
                    rowResult = new LinkedList();
                    EventBean event = this.eventAdapterService.adapterForBean(invocationResult);
                    rowResult.add(event);
                }
            }
        }
        catch (InvocationTargetException ex) {
            throw new EPException("Error invoking method '" + this.method.getName() + " on '" + this.method.getJavaMethod().getDeclaringClass().getName() + "'", ex);
        }
        return rowResult;
    }
}

