/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.esper.client.EPException;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.db.DataCache;
import net.esper.eql.db.PollExecStrategy;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.join.PollResultIndexingStrategy;
import net.esper.eql.join.table.EventTable;
import net.esper.eql.spec.MethodStreamSpec;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.schedule.TimeProvider;
import net.esper.view.HistoricalEventViewable;
import net.esper.view.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPollingViewable
implements HistoricalEventViewable {
    private final MethodStreamSpec methodStreamSpec;
    private final int myStreamNumber;
    private final PollExecStrategy pollExecStrategy;
    private final List<ExprNode> inputParameters;
    private final DataCache dataCache;
    private final EventType eventType;
    private ExprNode[] validatedExprNodes;

    public MethodPollingViewable(MethodStreamSpec methodStreamSpec, int myStreamNumber, List<ExprNode> inputParameters, PollExecStrategy pollExecStrategy, DataCache dataCache, EventType eventType) {
        this.methodStreamSpec = methodStreamSpec;
        this.myStreamNumber = myStreamNumber;
        this.inputParameters = inputParameters;
        this.pollExecStrategy = pollExecStrategy;
        this.dataCache = dataCache;
        this.eventType = eventType;
    }

    @Override
    public void stop() {
        this.pollExecStrategy.destroy();
    }

    @Override
    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        Object[] paramTypes = new Class[this.inputParameters.size()];
        int count = 0;
        this.validatedExprNodes = new ExprNode[this.inputParameters.size()];
        for (ExprNode exprNode : this.inputParameters) {
            ExprNode validated;
            this.validatedExprNodes[count] = validated = exprNode.getValidatedSubtree(streamTypeService, methodResolutionService, null, timeProvider, variableService);
            paramTypes[count] = validated.getType();
            ++count;
        }
        try {
            methodResolutionService.resolveMethod(this.methodStreamSpec.getClassName(), this.methodStreamSpec.getMethodName(), (Class[])paramTypes);
        }
        catch (Exception e) {
            if (this.inputParameters.size() == 0) {
                throw new ExprValidationException("Method footprint does not match the number or type of expression parameters, expecting no parameters in method: " + e.getMessage());
            }
            throw new ExprValidationException("Method footprint does not match the number or type of expression parameters, expecting a method where parameters are typed '" + Arrays.toString(paramTypes) + "': " + e.getMessage());
        }
    }

    @Override
    public EventTable[] poll(EventBean[][] lookupEventsPerStream, PollResultIndexingStrategy indexingStrategy) {
        this.pollExecStrategy.start();
        EventTable[] resultPerInputRow = new EventTable[lookupEventsPerStream.length];
        for (int row = 0; row < lookupEventsPerStream.length; ++row) {
            Object[] lookupValues = new Object[this.inputParameters.size()];
            for (int valueNum = 0; valueNum < this.inputParameters.size(); ++valueNum) {
                Object parameterValue;
                lookupValues[valueNum] = parameterValue = this.validatedExprNodes[valueNum].evaluate(lookupEventsPerStream[row], true);
            }
            EventTable result = this.dataCache.getCached(lookupValues);
            if (result != null) {
                resultPerInputRow[row] = result;
                continue;
            }
            try {
                EventTable indexTable;
                List<EventBean> pollResult = this.pollExecStrategy.poll(lookupValues);
                resultPerInputRow[row] = indexTable = indexingStrategy.index(pollResult, this.dataCache.isActive());
                this.dataCache.put(lookupValues, indexTable);
                continue;
            }
            catch (EPException ex) {
                this.pollExecStrategy.done();
                throw ex;
            }
        }
        this.pollExecStrategy.done();
        return resultPerInputRow;
    }

    @Override
    public View addView(View view) {
        return view;
    }

    @Override
    public List<View> getViews() {
        return new LinkedList<View>();
    }

    @Override
    public boolean removeView(View view) {
        throw new UnsupportedOperationException("Subviews not supported");
    }

    @Override
    public boolean hasViews() {
        return false;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Iterator not supported");
    }
}

