/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.lang.reflect.Method;
import net.esper.client.ConfigurationDBRef;
import net.esper.client.ConfigurationMethodRef;
import net.esper.core.EPStatementHandle;
import net.esper.eql.core.EngineImportService;
import net.esper.eql.core.MethodPollingExecStrategy;
import net.esper.eql.core.MethodPollingViewable;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.db.DataCache;
import net.esper.eql.db.DataCacheFactory;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.MethodStreamSpec;
import net.esper.event.EventAdapterService;
import net.esper.event.EventType;
import net.esper.schedule.ScheduleBucket;
import net.esper.schedule.SchedulingService;
import net.esper.util.JavaClassHelper;
import net.esper.view.HistoricalEventViewable;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class MethodPollingViewableFactory {
    public static HistoricalEventViewable createPollMethodView(int streamNumber, MethodStreamSpec methodStreamSpec, EventAdapterService eventAdapterService, EPStatementHandle epStatementHandle, MethodResolutionService methodResolutionService, EngineImportService engineImportService, SchedulingService schedulingService, ScheduleBucket scheduleBucket) throws ExprValidationException {
        FastMethod staticMethod;
        Class<?> declaringClass = null;
        try {
            Method method = methodResolutionService.resolveMethod(methodStreamSpec.getClassName(), methodStreamSpec.getMethodName());
            declaringClass = method.getDeclaringClass();
            FastClass declaringFastClass = FastClass.create(method.getDeclaringClass());
            staticMethod = declaringFastClass.getMethod(method);
        }
        catch (Exception e) {
            throw new ExprValidationException(e.getMessage());
        }
        Class<?> beanClass = staticMethod.getReturnType();
        if (beanClass == Void.TYPE || beanClass == Void.class || JavaClassHelper.isJavaBuiltinDataType(beanClass)) {
            throw new ExprValidationException("Invalid return type for static method '" + staticMethod.getName() + "' of class '" + methodStreamSpec.getClassName() + "', expecting a Java class");
        }
        if (staticMethod.getReturnType().isArray()) {
            beanClass = staticMethod.getReturnType().getComponentType();
        }
        EventType eventType = eventAdapterService.addBeanType(beanClass.getName(), beanClass);
        ConfigurationMethodRef configCache = engineImportService.getConfigurationMethodRef(declaringClass.getName());
        if (configCache == null) {
            configCache = engineImportService.getConfigurationMethodRef(declaringClass.getSimpleName());
        }
        ConfigurationDBRef.DataCacheDesc dataCacheDesc = configCache != null ? configCache.getDataCacheDesc() : null;
        DataCache dataCache = DataCacheFactory.getDataCache(dataCacheDesc, epStatementHandle, schedulingService, scheduleBucket);
        MethodPollingExecStrategy methodPollStrategy = new MethodPollingExecStrategy(eventAdapterService, staticMethod);
        return new MethodPollingViewable(methodStreamSpec, streamNumber, methodStreamSpec.getExpressions(), methodPollStrategy, dataCache, eventType);
    }
}

