/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.lang.reflect.Method;
import net.esper.client.EPException;
import net.esper.collection.MultiKeyUntyped;
import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.agg.AggregationSupport;
import net.esper.eql.agg.AvedevAggregator;
import net.esper.eql.agg.AvgAggregator;
import net.esper.eql.agg.CountAggregator;
import net.esper.eql.agg.DistinctValueAggregator;
import net.esper.eql.agg.DoubleSumAggregator;
import net.esper.eql.agg.FloatSumAggregator;
import net.esper.eql.agg.IntegerSumAggregator;
import net.esper.eql.agg.LongSumAggregator;
import net.esper.eql.agg.MedianAggregator;
import net.esper.eql.agg.MinMaxAggregator;
import net.esper.eql.agg.NonNullCountAggregator;
import net.esper.eql.agg.NumIntegerSumAggregator;
import net.esper.eql.agg.StddevAggregator;
import net.esper.eql.core.EngineImportException;
import net.esper.eql.core.EngineImportService;
import net.esper.eql.core.EngineImportUndefinedException;
import net.esper.eql.core.MethodResolutionService;
import net.esper.type.MinMaxTypeEnum;

public class MethodResolutionServiceImpl
implements MethodResolutionService {
    private final EngineImportService engineImportService;

    public MethodResolutionServiceImpl(EngineImportService engineImportService) {
        this.engineImportService = engineImportService;
    }

    public AggregationSupport makePlugInAggregator(String functionName) {
        try {
            return this.engineImportService.resolveAggregation(functionName);
        }
        catch (EngineImportUndefinedException e) {
            throw new EPException("Failed to make new aggregation function instance for '" + functionName + "'", e);
        }
        catch (EngineImportException e) {
            throw new EPException("Failed to make new aggregation function instance for '" + functionName + "'", e);
        }
    }

    public Method resolveMethod(String classNameAlias, String methodName, Class[] paramTypes) throws EngineImportException {
        return this.engineImportService.resolveMethod(classNameAlias, methodName, paramTypes);
    }

    public Method resolveMethod(String classNameAlias, String methodName) throws EngineImportException {
        return this.engineImportService.resolveMethod(classNameAlias, methodName);
    }

    public Class resolveClass(String classNameAlias) throws EngineImportException {
        return this.engineImportService.resolveClass(classNameAlias);
    }

    public Method resolveMethod(Class clazz, String methodName, Class[] paramTypes) throws EngineImportException {
        return this.engineImportService.resolveMethod(clazz, methodName, paramTypes);
    }

    public AggregationMethod makeCountAggregator(boolean isIgnoreNull) {
        if (isIgnoreNull) {
            return new NonNullCountAggregator();
        }
        return new CountAggregator();
    }

    public AggregationSupport resolveAggregation(String functionName) throws EngineImportUndefinedException, EngineImportException {
        return this.engineImportService.resolveAggregation(functionName);
    }

    public AggregationMethod makeSumAggregator(Class type) {
        if (type == Long.class || type == Long.TYPE) {
            return new LongSumAggregator();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerSumAggregator();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DoubleSumAggregator();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatSumAggregator();
        }
        return new NumIntegerSumAggregator();
    }

    public AggregationMethod makeDistinctAggregator(AggregationMethod aggregationMethod, Class childType) {
        return new DistinctValueAggregator(aggregationMethod, childType);
    }

    public AggregationMethod makeAvgAggregator() {
        return new AvgAggregator();
    }

    public AggregationMethod makeAvedevAggregator() {
        return new AvedevAggregator();
    }

    public AggregationMethod makeMedianAggregator() {
        return new MedianAggregator();
    }

    public AggregationMethod makeMinMaxAggregator(MinMaxTypeEnum minMaxTypeEnum, Class targetType) {
        return new MinMaxAggregator(minMaxTypeEnum, targetType);
    }

    public AggregationMethod makeStddevAggregator() {
        return new StddevAggregator();
    }

    public AggregationMethod[] newAggregators(AggregationMethod[] prototypes, MultiKeyUntyped groupKey) {
        AggregationMethod[] row = new AggregationMethod[prototypes.length];
        for (int i = 0; i < prototypes.length; ++i) {
            row[i] = prototypes[i].newAggregator(this);
        }
        return row;
    }
}

