/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.esper.eql.agg.AggregationService;
import net.esper.eql.core.OrderByProcessor;
import net.esper.eql.core.OrderByProcessorSimple;
import net.esper.eql.expression.ExprAggregateNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.OrderByItem;
import net.esper.eql.spec.SelectExprElementCompiledSpec;
import net.esper.event.EventAdapterService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByProcessorFactory {
    private static final Log log = LogFactory.getLog(OrderByProcessorFactory.class);

    public static OrderByProcessor getProcessor(List<SelectExprElementCompiledSpec> selectionList, List<ExprNode> groupByNodes, List<OrderByItem> orderByList, AggregationService aggregationService, EventAdapterService eventAdapterService) throws ExprValidationException {
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem element : orderByList) {
            orderByNodes.add(element.getExprNode());
        }
        if (orderByList.isEmpty()) {
            log.debug(".getProcessor Using no OrderByProcessor");
            return null;
        }
        LinkedList<ExprAggregateNode> selectAggNodes = new LinkedList<ExprAggregateNode>();
        for (SelectExprElementCompiledSpec element : selectionList) {
            ExprAggregateNode.getAggregatesBottomUp(element.getSelectExpression(), selectAggNodes);
        }
        LinkedList<ExprAggregateNode> orderAggNodes = new LinkedList<ExprAggregateNode>();
        for (ExprNode orderByNode : orderByNodes) {
            ExprAggregateNode.getAggregatesBottomUp(orderByNode, orderAggNodes);
        }
        OrderByProcessorFactory.validateOrderByAggregates(selectAggNodes, orderAggNodes);
        HashMap<String, Class> propertyNamesAndTypes = new HashMap<String, Class>();
        for (ExprNode orderByNode : orderByNodes) {
            propertyNamesAndTypes.put(orderByNode.toExpressionString(), orderByNode.getType());
        }
        boolean needsGroupByKeys = !selectionList.isEmpty() && !orderAggNodes.isEmpty();
        log.debug(".getProcessor Using OrderByProcessorSimple");
        return new OrderByProcessorSimple(orderByList, groupByNodes, needsGroupByKeys, aggregationService);
    }

    private static void validateOrderByAggregates(List<ExprAggregateNode> selectAggNodes, List<ExprAggregateNode> orderAggNodes) throws ExprValidationException {
        for (ExprAggregateNode orderAgg : orderAggNodes) {
            boolean inSelect = false;
            for (ExprAggregateNode selectAgg : selectAggNodes) {
                if (!ExprNode.deepEquals(selectAgg, orderAgg)) continue;
                inSelect = true;
                break;
            }
            if (inSelect) continue;
            throw new ExprValidationException("Aggregate functions in the order-by clause must also occur in the select expression");
        }
    }
}

