/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.esper.eql.core.ResultSetProcessorAggregateAll;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetAggregateAllIterator
implements Iterator<EventBean> {
    private final Iterator<EventBean> sourceIterator;
    private final ResultSetProcessorAggregateAll resultSetProcessor;
    private EventBean nextResult;
    private final EventBean[] eventsPerStream;

    public ResultSetAggregateAllIterator(Iterator<EventBean> sourceIterator, ResultSetProcessorAggregateAll resultSetProcessor) {
        this.sourceIterator = sourceIterator;
        this.resultSetProcessor = resultSetProcessor;
        this.eventsPerStream = new EventBean[1];
    }

    @Override
    public boolean hasNext() {
        if (this.nextResult != null) {
            return true;
        }
        this.findNext();
        return this.nextResult != null;
    }

    @Override
    public EventBean next() {
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        this.findNext();
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNext() {
        while (this.sourceIterator.hasNext()) {
            EventBean candidate;
            this.eventsPerStream[0] = candidate = this.sourceIterator.next();
            Boolean pass = true;
            if (this.resultSetProcessor.getOptionalHavingNode() != null) {
                pass = (Boolean)this.resultSetProcessor.getOptionalHavingNode().evaluate(this.eventsPerStream, true);
            }
            if (!pass.booleanValue()) continue;
            if (this.resultSetProcessor.getSelectExprProcessor() == null) {
                this.nextResult = candidate;
                break;
            }
            this.nextResult = this.resultSetProcessor.getSelectExprProcessor().process(this.eventsPerStream, true);
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

