/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.esper.collection.ArrayEventIterator;
import net.esper.collection.MultiKey;
import net.esper.collection.MultiKeyUntyped;
import net.esper.collection.Pair;
import net.esper.eql.agg.AggregationService;
import net.esper.eql.core.OrderByProcessor;
import net.esper.eql.core.ResultSetAggregateAllIterator;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.core.ResultSetProcessorSimple;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.expression.ExprNode;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.Viewable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorAggregateAll
implements ResultSetProcessor {
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    private final AggregationService aggregationService;
    private final ExprNode optionalHavingNode;
    private final boolean isOutputLimiting;
    private final boolean isOutputLimitLastOnly;

    public ResultSetProcessorAggregateAll(SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, ExprNode optionalHavingNode, boolean isOutputLimiting, boolean isOutputLimitLastOnly) {
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.optionalHavingNode = optionalHavingNode;
        this.isOutputLimiting = isOutputLimiting;
        this.isOutputLimitLastOnly = isOutputLimitLastOnly;
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public Pair<EventBean[], EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        EventBean[] selectOldEvents = null;
        EventBean[] selectNewEvents = null;
        selectOldEvents = this.optionalHavingNode == null ? ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, oldEvents, this.isOutputLimiting, this.isOutputLimitLastOnly, false) : ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, oldEvents, this.optionalHavingNode, this.isOutputLimiting, this.isOutputLimitLastOnly, false);
        if (!newEvents.isEmpty()) {
            for (MultiKey<EventBean> events : newEvents) {
                this.aggregationService.applyEnter(events.getArray(), null);
            }
        }
        if (!oldEvents.isEmpty()) {
            for (MultiKey<EventBean> events : oldEvents) {
                this.aggregationService.applyLeave(events.getArray(), null);
            }
        }
        if ((selectNewEvents = this.optionalHavingNode == null ? ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, newEvents, this.isOutputLimiting, this.isOutputLimitLastOnly, true) : ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, newEvents, this.optionalHavingNode, this.isOutputLimiting, this.isOutputLimitLastOnly, true)) == null && selectOldEvents == null) {
            return null;
        }
        return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public Pair<EventBean[], EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData) {
        int i;
        EventBean[] selectOldEvents = null;
        EventBean[] selectNewEvents = null;
        selectOldEvents = this.optionalHavingNode == null ? ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, oldData, this.isOutputLimiting, this.isOutputLimitLastOnly, false) : ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, oldData, this.optionalHavingNode, this.isOutputLimiting, this.isOutputLimitLastOnly, false);
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, null);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, null);
            }
        }
        if ((selectNewEvents = this.optionalHavingNode == null ? ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, newData, this.isOutputLimiting, this.isOutputLimitLastOnly, true) : ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, newData, this.optionalHavingNode, this.isOutputLimiting, this.isOutputLimitLastOnly, true)) == null && selectOldEvents == null) {
            return null;
        }
        return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetAggregateAllIterator(parent.iterator(), this);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<MultiKeyUntyped> orderKeys = new ArrayList<MultiKeyUntyped>();
        Iterator<EventBean> it = parent.iterator();
        while (it.hasNext()) {
            EventBean candidate;
            eventsPerStream[0] = candidate = it.next();
            Boolean pass = true;
            if (this.optionalHavingNode != null) {
                pass = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, true);
            }
            if (!pass.booleanValue()) continue;
            if (this.selectExprProcessor == null) {
                outgoingEvents.add(candidate);
            } else {
                outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true));
            }
            MultiKeyUntyped orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[0]);
        MultiKeyUntyped[] orderKeysArr = orderKeys.toArray(new MultiKeyUntyped[0]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr);
        return new ArrayEventIterator(orderedEvents);
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    public ExprNode getOptionalHavingNode() {
        return this.optionalHavingNode;
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        EventBean[] result = this.optionalHavingNode == null ? ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, joinSet, this.isOutputLimiting, this.isOutputLimitLastOnly, true) : ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, joinSet, this.optionalHavingNode, this.isOutputLimiting, this.isOutputLimitLastOnly, true);
        return new ArrayEventIterator(result);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults();
    }
}

