/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.esper.collection.ArrayEventIterator;
import net.esper.collection.MultiKey;
import net.esper.collection.MultiKeyUntyped;
import net.esper.collection.Pair;
import net.esper.eql.agg.AggregationService;
import net.esper.eql.core.OrderByProcessor;
import net.esper.eql.core.ResultSetAggregateGroupedIterator;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.expression.ExprNode;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.Viewable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorAggregateGrouped
implements ResultSetProcessor {
    private static final Log log = LogFactory.getLog(ResultSetProcessorAggregateGrouped.class);
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    private final AggregationService aggregationService;
    private final List<ExprNode> groupKeyNodes;
    private final ExprNode optionalHavingNode;
    private final boolean isOutputLimiting;
    private final boolean isOutputLimitLastOnly;
    private final boolean isSorting;
    private final Map<MultiKeyUntyped, EventBean> oldEventGroupReps = new HashMap<MultiKeyUntyped, EventBean>();
    private final Map<MultiKeyUntyped, EventBean> newEventGroupReps = new HashMap<MultiKeyUntyped, EventBean>();
    private final Map<MultiKeyUntyped, EventBean[]> newGenerators = new HashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, EventBean[]> oldGenerators = new HashMap<MultiKeyUntyped, EventBean[]>();

    public ResultSetProcessorAggregateGrouped(SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, List<ExprNode> groupKeyNodes, ExprNode optionalHavingNode, boolean isOutputLimiting, boolean isOutputLimitLastOnly) {
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.groupKeyNodes = groupKeyNodes;
        this.optionalHavingNode = optionalHavingNode;
        this.isOutputLimiting = isOutputLimiting;
        this.isOutputLimitLastOnly = isOutputLimitLastOnly;
        this.isSorting = orderByProcessor != null;
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public Pair<EventBean[], EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        EventBean[] selectNewEvents;
        int count;
        MultiKeyUntyped[] newDataGroupByKeys = this.generateGroupKeys(newEvents, true);
        MultiKeyUntyped[] oldDataGroupByKeys = this.generateGroupKeys(oldEvents, false);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".processJoinResults creating old output events");
        }
        EventBean[] selectOldEvents = this.generateOutputEventsJoin(oldEvents, oldDataGroupByKeys, this.optionalHavingNode, this.oldEventGroupReps, this.oldGenerators, false);
        if (!newEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                this.aggregationService.applyEnter(eventsPerStream.getArray(), newDataGroupByKeys[count]);
                ++count;
            }
        }
        if (!oldEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                this.aggregationService.applyLeave(eventsPerStream.getArray(), oldDataGroupByKeys[count]);
                ++count;
            }
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".processJoinResults creating new output events");
        }
        if ((selectNewEvents = this.generateOutputEventsJoin(newEvents, newDataGroupByKeys, this.optionalHavingNode, this.newEventGroupReps, this.newGenerators, true)) != null || selectOldEvents != null) {
            return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public Pair<EventBean[], EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData) {
        EventBean[] selectNewEvents;
        int i;
        MultiKeyUntyped[] newDataGroupByKeys = this.generateGroupKeys(newData, true);
        MultiKeyUntyped[] oldDataGroupByKeys = this.generateGroupKeys(oldData, false);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".processViewResults creating old output events");
        }
        EventBean[] selectOldEvents = this.generateOutputEventsView(oldData, oldDataGroupByKeys, this.optionalHavingNode, this.oldEventGroupReps, this.oldGenerators, false);
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataGroupByKeys[i]);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataGroupByKeys[i]);
            }
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".processViewResults creating new output events");
        }
        if ((selectNewEvents = this.generateOutputEventsView(newData, newDataGroupByKeys, this.optionalHavingNode, this.newEventGroupReps, this.newGenerators, true)) != null || selectOldEvents != null) {
            return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    private EventBean[] applyOutputLimitAndOrderBy(EventBean[] events, EventBean[][] currentGenerators, MultiKeyUntyped[] keys, Map<MultiKeyUntyped, EventBean> groupReps, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData) {
        if (this.isOutputLimiting && !this.isOutputLimitLastOnly) {
            LinkedHashSet<MultiKeyUntyped> notUpdatedKeys = new LinkedHashSet<MultiKeyUntyped>(groupReps.keySet());
            int countOne = 0;
            for (MultiKeyUntyped key : keys) {
                notUpdatedKeys.remove(key);
                groupReps.put(key, events[countOne++]);
            }
            int outputLength = events.length + notUpdatedKeys.size();
            EventBean[] result = new EventBean[outputLength];
            int countTwo = 0;
            for (EventBean event : events) {
                result[countTwo++] = event;
            }
            for (MultiKeyUntyped key : notUpdatedKeys) {
                result[countTwo++] = groupReps.get(key);
            }
            events = result;
            if (this.isSorting) {
                MultiKeyUntyped[] sortKeys = new MultiKeyUntyped[outputLength];
                int countThree = 0;
                for (MultiKeyUntyped key : keys) {
                    sortKeys[countThree++] = key;
                }
                for (MultiKeyUntyped key : notUpdatedKeys) {
                    sortKeys[countThree++] = key;
                }
                keys = sortKeys;
                EventBean[][] sortGenerators = new EventBean[outputLength][];
                int countFour = 0;
                for (EventBean[] gens : currentGenerators) {
                    sortGenerators[countFour++] = gens;
                }
                for (MultiKeyUntyped key : notUpdatedKeys) {
                    sortGenerators[countFour++] = generators.get(key);
                }
                currentGenerators = sortGenerators;
            }
        }
        if (this.isSorting) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData);
        }
        return events;
    }

    private EventBean[] generateOutputEventsView(EventBean[] outputEvents, MultiKeyUntyped[] groupByKeys, ExprNode optionalHavingExpr, Map<MultiKeyUntyped, EventBean> groupReps, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData) {
        if (outputEvents == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] events = new EventBean[outputEvents.length];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[outputEvents.length];
        EventBean[][] currentGenerators = null;
        if (this.isSorting) {
            currentGenerators = new EventBean[outputEvents.length][];
        }
        int count = 0;
        for (int i = 0; i < outputEvents.length; ++i) {
            Boolean result;
            this.aggregationService.setCurrentRow(groupByKeys[count]);
            eventsPerStream[0] = outputEvents[count];
            if (optionalHavingExpr != null && !(result = (Boolean)optionalHavingExpr.evaluate(eventsPerStream, isNewData)).booleanValue()) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData);
            keys[count] = groupByKeys[count];
            if (this.isSorting) {
                EventBean[] currentEventsPerStream = new EventBean[]{outputEvents[count]};
                generators.put(keys[count], currentEventsPerStream);
                currentGenerators[count] = currentEventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.isSorting || this.isOutputLimiting && !this.isOutputLimitLastOnly) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
            }
            if (this.isSorting) {
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        return this.applyOutputLimitAndOrderBy(events, currentGenerators, keys, groupReps, generators, isNewData);
    }

    private MultiKeyUntyped[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, boolean isNewData) {
        if (resultSet.isEmpty()) {
            return null;
        }
        MultiKeyUntyped[] keys = new MultiKeyUntyped[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            ++count;
        }
        return keys;
    }

    private MultiKeyUntyped[] generateGroupKeys(EventBean[] events, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
        }
        return keys;
    }

    protected MultiKeyUntyped generateGroupKey(EventBean[] eventsPerStream, boolean isNewData) {
        Object[] keys = new Object[this.groupKeyNodes.size()];
        int count = 0;
        for (ExprNode exprNode : this.groupKeyNodes) {
            keys[count] = exprNode.evaluate(eventsPerStream, isNewData);
            ++count;
        }
        return new MultiKeyUntyped(keys);
    }

    private EventBean[] generateOutputEventsJoin(Set<MultiKey<EventBean>> resultSet, MultiKeyUntyped[] groupByKeys, ExprNode optionalHavingExpr, Map<MultiKeyUntyped, EventBean> groupReps, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData) {
        if (resultSet.isEmpty()) {
            return null;
        }
        EventBean[] events = new EventBean[resultSet.size()];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[resultSet.size()];
        EventBean[][] currentGenerators = null;
        if (this.isSorting) {
            currentGenerators = new EventBean[resultSet.size()][];
        }
        int count = 0;
        for (MultiKey<EventBean> row : resultSet) {
            Boolean result;
            EventBean[] eventsPerStream = row.getArray();
            this.aggregationService.setCurrentRow(groupByKeys[count]);
            if (optionalHavingExpr != null && !(result = (Boolean)optionalHavingExpr.evaluate(eventsPerStream, isNewData)).booleanValue()) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData);
            keys[count] = groupByKeys[count];
            if (this.isSorting) {
                generators.put(keys[count], eventsPerStream);
                currentGenerators[count] = eventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.isSorting || this.isOutputLimiting && !this.isOutputLimitLastOnly) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
            }
            if (this.isSorting) {
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        return this.applyOutputLimitAndOrderBy(events, currentGenerators, keys, groupReps, generators, isNewData);
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetAggregateGroupedIterator(parent.iterator(), this, this.aggregationService);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<MultiKeyUntyped> orderKeys = new ArrayList<MultiKeyUntyped>();
        Iterator<EventBean> it = parent.iterator();
        while (it.hasNext()) {
            EventBean candidate;
            eventsPerStream[0] = candidate = it.next();
            MultiKeyUntyped groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.setCurrentRow(groupKey);
            Boolean pass = true;
            if (this.optionalHavingNode != null) {
                pass = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, true);
            }
            if (!pass.booleanValue()) continue;
            if (this.selectExprProcessor == null) {
                outgoingEvents.add(candidate);
            } else {
                outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true));
            }
            MultiKeyUntyped orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[0]);
        MultiKeyUntyped[] orderKeysArr = orderKeys.toArray(new MultiKeyUntyped[0]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr);
        return new ArrayEventIterator(orderedEvents);
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    public ExprNode getOptionalHavingNode() {
        return this.optionalHavingNode;
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        MultiKeyUntyped[] groupByKeys = this.generateGroupKeys(joinSet, true);
        EventBean[] result = this.generateOutputEventsJoin(joinSet, groupByKeys, this.optionalHavingNode, this.newEventGroupReps, this.newGenerators, true);
        return new ArrayEventIterator(result);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults();
    }
}

