/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.esper.collection.Pair;
import net.esper.eql.agg.AggregationService;
import net.esper.eql.agg.AggregationServiceFactory;
import net.esper.eql.core.AliasNodeSwapper;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.OrderByProcessor;
import net.esper.eql.core.OrderByProcessorFactory;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.core.ResultSetProcessorAggregateAll;
import net.esper.eql.core.ResultSetProcessorAggregateGrouped;
import net.esper.eql.core.ResultSetProcessorRowForAll;
import net.esper.eql.core.ResultSetProcessorRowPerGroup;
import net.esper.eql.core.ResultSetProcessorSimple;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.core.SelectExprProcessorFactory;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprAggregateNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprNodeIdentifierVisitor;
import net.esper.eql.expression.ExprNodeSubselectVisitor;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.InsertIntoDesc;
import net.esper.eql.spec.OrderByItem;
import net.esper.eql.spec.OutputLimitLimitType;
import net.esper.eql.spec.OutputLimitSpec;
import net.esper.eql.spec.SelectClauseSpec;
import net.esper.eql.spec.SelectExprElementCompiledSpec;
import net.esper.eql.spec.SelectExprElementRawSpec;
import net.esper.eql.spec.SelectExprElementStreamCompiledSpec;
import net.esper.eql.spec.SelectExprElementStreamRawSpec;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventAdapterService;
import net.esper.event.TaggedCompositeEventType;
import net.esper.schedule.TimeProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorFactory {
    private static final Log log = LogFactory.getLog(ResultSetProcessorFactory.class);

    public static ResultSetProcessor getProcessor(SelectClauseSpec selectClauseSpec, InsertIntoDesc insertIntoDesc, List<ExprNode> groupByNodes, ExprNode optionalHavingNode, OutputLimitSpec outputLimitSpec, List<OrderByItem> orderByList, StreamTypeService typeService, EventAdapterService eventAdapterService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        boolean hasAggregation;
        boolean isOutputLimitLastOnly;
        boolean isOutputLimiting;
        if (log.isDebugEnabled()) {
            log.debug(".getProcessor Getting processor for  selectionList=" + selectClauseSpec.getSelectExprList() + " isUsingWildcard=" + selectClauseSpec.isUsingWildcard() + " groupByNodes=" + Arrays.toString(groupByNodes.toArray()) + " optionalHavingNode=" + optionalHavingNode);
        }
        ResultSetProcessorFactory.expandAliases(selectClauseSpec.getSelectExprList(), orderByList);
        LinkedList<SelectExprElementCompiledSpec> namedSelectionList = new LinkedList<SelectExprElementCompiledSpec>();
        for (int i = 0; i < selectClauseSpec.getSelectExprList().size(); ++i) {
            SelectExprElementRawSpec element = selectClauseSpec.getSelectExprList().get(i);
            ExprNode validatedExpression = element.getSelectExpression().getValidatedSubtree(typeService, methodResolutionService, viewResourceDelegate, timeProvider, variableService);
            String asName = element.getOptionalAsName();
            if (asName == null) {
                asName = validatedExpression.toExpressionString();
            }
            SelectExprElementCompiledSpec validatedElement = new SelectExprElementCompiledSpec(validatedExpression, asName);
            namedSelectionList.add(validatedElement);
        }
        boolean isUsingWildcard = selectClauseSpec.isUsingWildcard();
        LinkedList<SelectExprElementStreamCompiledSpec> namedStreamList = new LinkedList<SelectExprElementStreamCompiledSpec>();
        for (SelectExprElementStreamRawSpec raw : selectClauseSpec.getSelectStreamsList()) {
            int streamNum = Integer.MIN_VALUE;
            boolean isTaggedEvent = false;
            for (int i = 0; i < typeService.getStreamNames().length; ++i) {
                TaggedCompositeEventType compositeType;
                String streamAlias = raw.getStreamAliasName();
                if (typeService.getStreamNames()[i].equals(streamAlias)) {
                    streamNum = i;
                    break;
                }
                if (!(typeService.getEventTypes()[i] instanceof TaggedCompositeEventType) || (compositeType = (TaggedCompositeEventType)((Object)typeService.getEventTypes()[i])).getTaggedEventTypes().get(streamAlias) == null) continue;
                streamNum = i;
                isTaggedEvent = true;
                break;
            }
            if (streamNum == Integer.MIN_VALUE) {
                throw new ExprValidationException("Stream selector '" + raw.getStreamAliasName() + ".*' does not match any stream alias name in the from clause");
            }
            SelectExprElementStreamCompiledSpec validatedElement = new SelectExprElementStreamCompiledSpec(raw.getStreamAliasName(), raw.getOptionalAsName(), streamNum, isTaggedEvent);
            namedStreamList.add(validatedElement);
        }
        selectClauseSpec = null;
        for (int i = 0; i < groupByNodes.size(); ++i) {
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            groupByNodes.get(i).accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within group-by");
            }
            groupByNodes.set(i, groupByNodes.get(i).getValidatedSubtree(typeService, methodResolutionService, viewResourceDelegate, timeProvider, variableService));
        }
        if (optionalHavingNode != null) {
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            optionalHavingNode.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within having-clause");
            }
            optionalHavingNode = optionalHavingNode.getValidatedSubtree(typeService, methodResolutionService, viewResourceDelegate, timeProvider, variableService);
        }
        for (int i = 0; i < orderByList.size(); ++i) {
            ExprNode orderByNode = orderByList.get(i).getExprNode();
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            orderByNode.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within order-by clause");
            }
            Boolean isDescending = orderByList.get(i).isDescending();
            OrderByItem validatedOrderBy = new OrderByItem(orderByNode.getValidatedSubtree(typeService, methodResolutionService, viewResourceDelegate, timeProvider, variableService), isDescending);
            orderByList.set(i, validatedOrderBy);
        }
        ArrayList<ExprNode> selectNodes = new ArrayList<ExprNode>();
        for (SelectExprElementCompiledSpec element : namedSelectionList) {
            selectNodes.add(element.getSelectExpression());
        }
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem element : orderByList) {
            orderByNodes.add(element.getExprNode());
        }
        LinkedList<ExprAggregateNode> selectAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        for (SelectExprElementCompiledSpec element : namedSelectionList) {
            ExprAggregateNode.getAggregatesBottomUp(element.getSelectExpression(), selectAggregateExprNodes);
        }
        LinkedList<ExprAggregateNode> havingAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        Set<Object> propertiesAggregatedHaving = new HashSet();
        if (optionalHavingNode != null) {
            ExprAggregateNode.getAggregatesBottomUp(optionalHavingNode, havingAggregateExprNodes);
            propertiesAggregatedHaving = ResultSetProcessorFactory.getAggregatedProperties(havingAggregateExprNodes);
        }
        LinkedList<ExprAggregateNode> orderByAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        if (orderByNodes != null) {
            for (ExprNode orderByNode : orderByNodes) {
                ExprAggregateNode.getAggregatesBottomUp(orderByNode, orderByAggregateExprNodes);
            }
        }
        boolean hasGroupBy = !groupByNodes.isEmpty();
        AggregationService aggregationService = AggregationServiceFactory.getService(selectAggregateExprNodes, havingAggregateExprNodes, orderByAggregateExprNodes, hasGroupBy, methodResolutionService);
        OrderByProcessor orderByProcessor = OrderByProcessorFactory.getProcessor(namedSelectionList, groupByNodes, orderByList, aggregationService, eventAdapterService);
        SelectExprProcessor selectExprProcessor = SelectExprProcessorFactory.getProcessor(namedSelectionList, namedStreamList, isUsingWildcard, insertIntoDesc, typeService, eventAdapterService);
        Set<Pair<Integer, String>> propertiesAggregatedSelect = ResultSetProcessorFactory.getAggregatedProperties(selectAggregateExprNodes);
        Set<Pair<Integer, String>> propertiesGroupBy = ResultSetProcessorFactory.getGroupByProperties(groupByNodes);
        Set<Pair<Integer, String>> nonAggregatedProps = ResultSetProcessorFactory.getNonAggregatedProps(selectNodes);
        ResultSetProcessorFactory.validateGroupBy(groupByNodes, propertiesAggregatedSelect, propertiesGroupBy);
        if (optionalHavingNode != null) {
            ResultSetProcessorFactory.validateHaving(selectAggregateExprNodes, propertiesGroupBy, optionalHavingNode);
        }
        boolean bl = isOutputLimiting = outputLimitSpec != null;
        boolean bl2 = outputLimitSpec != null ? outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.LAST : (isOutputLimitLastOnly = false);
        if (groupByNodes.isEmpty() && selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            if (selectExprProcessor == null && orderByNodes.isEmpty() && optionalHavingNode == null) {
                log.debug(".getProcessor Using no result processor");
                return null;
            }
            log.debug(".getProcessor Using ResultSetProcessorSimple");
            return new ResultSetProcessorSimple(selectExprProcessor, orderByProcessor, optionalHavingNode, isOutputLimiting, isOutputLimitLastOnly);
        }
        if (namedSelectionList.isEmpty() && propertiesAggregatedHaving.isEmpty()) {
            log.debug(".getProcessor Using ResultSetProcessorSimple");
            return new ResultSetProcessorSimple(selectExprProcessor, orderByProcessor, optionalHavingNode, isOutputLimiting, isOutputLimitLastOnly);
        }
        boolean bl3 = hasAggregation = !selectAggregateExprNodes.isEmpty() || !propertiesAggregatedHaving.isEmpty();
        if (groupByNodes.isEmpty() && hasAggregation) {
            if (nonAggregatedProps.isEmpty() && !isUsingWildcard) {
                log.debug(".getProcessor Using ResultSetProcessorRowForAll");
                return new ResultSetProcessorRowForAll(selectExprProcessor, aggregationService, optionalHavingNode);
            }
            log.debug(".getProcessor Using ResultSetProcessorAggregateAll");
            return new ResultSetProcessorAggregateAll(selectExprProcessor, orderByProcessor, aggregationService, optionalHavingNode, isOutputLimiting, isOutputLimitLastOnly);
        }
        if (groupByNodes.isEmpty()) {
            throw new IllegalStateException("Unexpected empty group-by expression list");
        }
        Set<Pair<Integer, String>> nonAggregatedPropsSelect = ResultSetProcessorFactory.getNonAggregatedProps(selectNodes);
        boolean allInGroupBy = true;
        for (Pair<Integer, String> nonAggregatedProp : nonAggregatedPropsSelect) {
            if (propertiesGroupBy.contains(nonAggregatedProp)) continue;
            allInGroupBy = false;
        }
        if (namedSelectionList.isEmpty()) {
            allInGroupBy = false;
        }
        Set<Pair<Integer, String>> nonAggregatedPropsOrderBy = ResultSetProcessorFactory.getNonAggregatedProps(orderByNodes);
        boolean allInSelect = true;
        for (Pair<Integer, String> nonAggregatedProp : nonAggregatedPropsOrderBy) {
            if (nonAggregatedPropsSelect.contains(nonAggregatedProp)) continue;
            allInSelect = false;
        }
        if (namedSelectionList.isEmpty()) {
            allInSelect = true;
        }
        if (allInGroupBy && allInSelect) {
            log.debug(".getProcessor Using ResultSetProcessorRowPerGroup");
            return new ResultSetProcessorRowPerGroup(selectExprProcessor, orderByProcessor, aggregationService, groupByNodes, optionalHavingNode, isOutputLimiting, isOutputLimitLastOnly);
        }
        log.debug(".getProcessor Using ResultSetProcessorAggregateGrouped");
        return new ResultSetProcessorAggregateGrouped(selectExprProcessor, orderByProcessor, aggregationService, groupByNodes, optionalHavingNode, isOutputLimiting, isOutputLimitLastOnly);
    }

    private static void validateHaving(List<ExprAggregateNode> selectAggregateExprNodes, Set<Pair<Integer, String>> propertiesGroupedBy, ExprNode havingNode) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggregateNodesHaving = new LinkedList<ExprAggregateNode>();
        if (aggregateNodesHaving != null) {
            ExprAggregateNode.getAggregatesBottomUp(havingNode, aggregateNodesHaving);
        }
        if (!propertiesGroupedBy.isEmpty()) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            havingNode.accept(visitor);
            List<Pair<Integer, String>> allPropertiesHaving = visitor.getExprProperties();
            Set<Pair<Integer, String>> aggPropertiesHaving = ResultSetProcessorFactory.getAggregatedProperties(aggregateNodesHaving);
            allPropertiesHaving.removeAll(aggPropertiesHaving);
            allPropertiesHaving.removeAll(propertiesGroupedBy);
            if (!allPropertiesHaving.isEmpty()) {
                String name = allPropertiesHaving.iterator().next().getSecond();
                throw new ExprValidationException("Non-aggregated property '" + name + "' in the HAVING clause must occur in the group-by clause");
            }
        }
    }

    private static void validateGroupBy(List<ExprNode> groupByNodes, Set<Pair<Integer, String>> propertiesAggregated, Set<Pair<Integer, String>> propertiesGroupedBy) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggNodes = new LinkedList<ExprAggregateNode>();
        for (ExprNode exprNode : groupByNodes) {
            ExprAggregateNode.getAggregatesBottomUp(exprNode, aggNodes);
            if (aggNodes.isEmpty()) continue;
            throw new ExprValidationException("Group-by expressions cannot contain aggregate functions");
        }
        for (Pair pair : propertiesAggregated) {
            if (!propertiesGroupedBy.contains(pair)) continue;
            throw new ExprValidationException("Group-by property '" + (String)pair.getSecond() + "' cannot also occur in an aggregate function in the select clause");
        }
    }

    private static Set<Pair<Integer, String>> getNonAggregatedProps(List<ExprNode> exprNodes) {
        HashSet<Pair<Integer, String>> nonAggProps = new HashSet<Pair<Integer, String>>();
        for (ExprNode node : exprNodes) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(false);
            node.accept(visitor);
            List<Pair<Integer, String>> propertiesNode = visitor.getExprProperties();
            nonAggProps.addAll(propertiesNode);
        }
        return nonAggProps;
    }

    private static Set<Pair<Integer, String>> getAggregatedProperties(List<ExprAggregateNode> aggregateNodes) {
        HashSet<Pair<Integer, String>> propertiesAggregated = new HashSet<Pair<Integer, String>>();
        for (ExprAggregateNode selectAggExprNode : aggregateNodes) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            selectAggExprNode.accept(visitor);
            List<Pair<Integer, String>> properties = visitor.getExprProperties();
            propertiesAggregated.addAll(properties);
        }
        return propertiesAggregated;
    }

    private static Set<Pair<Integer, String>> getGroupByProperties(List<ExprNode> groupByNodes) throws ExprValidationException {
        HashSet<Pair<Integer, String>> propertiesGroupBy = new HashSet<Pair<Integer, String>>();
        for (ExprNode groupByNode : groupByNodes) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            groupByNode.accept(visitor);
            List<Pair<Integer, String>> propertiesNode = visitor.getExprProperties();
            propertiesGroupBy.addAll(propertiesNode);
            if (!propertiesNode.isEmpty()) continue;
            throw new ExprValidationException("Group-by expressions must refer to property names");
        }
        return propertiesGroupBy;
    }

    private static void expandAliases(List<SelectExprElementRawSpec> selectionList, List<OrderByItem> orderByList) {
        for (SelectExprElementRawSpec selectElement : selectionList) {
            String alias = selectElement.getOptionalAsName();
            if (alias == null) continue;
            ExprNode fullExpr = selectElement.getSelectExpression();
            ListIterator<OrderByItem> iterator = orderByList.listIterator();
            while (iterator.hasNext()) {
                OrderByItem orderByElement = iterator.next();
                ExprNode swapped = AliasNodeSwapper.swap(orderByElement.getExprNode(), alias, fullExpr);
                OrderByItem newOrderByElement = new OrderByItem(swapped, orderByElement.isDescending());
                iterator.set(newOrderByElement);
            }
        }
    }
}

