/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.Iterator;
import java.util.Set;
import net.esper.collection.ArrayEventIterator;
import net.esper.collection.MultiKey;
import net.esper.collection.NullIterator;
import net.esper.collection.Pair;
import net.esper.collection.SingleEventIterator;
import net.esper.eql.agg.AggregationService;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.expression.ExprNode;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.Viewable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorRowForAll
implements ResultSetProcessor {
    private final SelectExprProcessor selectExprProcessor;
    private final AggregationService aggregationService;
    private final ExprNode optionalHavingNode;

    public ResultSetProcessorRowForAll(SelectExprProcessor selectExprProcessor, AggregationService aggregationService, ExprNode optionalHavingNode) {
        this.selectExprProcessor = selectExprProcessor;
        this.aggregationService = aggregationService;
        this.optionalHavingNode = optionalHavingNode;
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public Pair<EventBean[], EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        EventBean[] selectNewEvents;
        EventBean[] selectOldEvents = ResultSetProcessorRowForAll.getSelectListEvents(this.selectExprProcessor, this.optionalHavingNode, false);
        if (!newEvents.isEmpty()) {
            for (MultiKey<EventBean> events : newEvents) {
                this.aggregationService.applyEnter(events.getArray(), null);
            }
        }
        if (!oldEvents.isEmpty()) {
            for (MultiKey<EventBean> events : oldEvents) {
                this.aggregationService.applyLeave(events.getArray(), null);
            }
        }
        if ((selectNewEvents = ResultSetProcessorRowForAll.getSelectListEvents(this.selectExprProcessor, this.optionalHavingNode, true)) == null && selectOldEvents == null) {
            return null;
        }
        return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public Pair<EventBean[], EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData) {
        int i;
        EventBean[] selectOldEvents = null;
        EventBean[] selectNewEvents = null;
        selectOldEvents = ResultSetProcessorRowForAll.getSelectListEvents(this.selectExprProcessor, this.optionalHavingNode, false);
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, null);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, null);
            }
        }
        if ((selectNewEvents = ResultSetProcessorRowForAll.getSelectListEvents(this.selectExprProcessor, this.optionalHavingNode, true)) == null && selectOldEvents == null) {
            return null;
        }
        return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
    }

    private static EventBean[] getSelectListEvents(SelectExprProcessor exprProcessor, ExprNode optionalHavingNode, boolean isNewData) {
        Boolean result;
        EventBean event = exprProcessor.process(null, isNewData);
        if (optionalHavingNode != null && !(result = (Boolean)optionalHavingNode.evaluate(null, isNewData)).booleanValue()) {
            return null;
        }
        return new EventBean[]{event};
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        EventBean[] selectNewEvents = ResultSetProcessorRowForAll.getSelectListEvents(this.selectExprProcessor, this.optionalHavingNode, true);
        if (selectNewEvents == null) {
            return new NullIterator<EventBean>();
        }
        return new SingleEventIterator(selectNewEvents[0]);
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        EventBean[] result = ResultSetProcessorRowForAll.getSelectListEvents(this.selectExprProcessor, this.optionalHavingNode, true);
        return new ArrayEventIterator(result);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults();
    }
}

