/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.esper.collection.ArrayEventIterator;
import net.esper.collection.MultiKey;
import net.esper.collection.MultiKeyUntyped;
import net.esper.collection.Pair;
import net.esper.eql.agg.AggregationService;
import net.esper.eql.core.OrderByProcessor;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.core.ResultSetRowPerGroupIterator;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.expression.ExprNode;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.Viewable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorRowPerGroup
implements ResultSetProcessor {
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    private final AggregationService aggregationService;
    private final List<ExprNode> groupKeyNodes;
    private final ExprNode optionalHavingNode;
    private final boolean isOutputLimiting;
    private final boolean isOutputLimitLastOnly;
    private final boolean isSorting;
    private final Map<MultiKeyUntyped, EventBean> newEventGroupReps = new LinkedHashMap<MultiKeyUntyped, EventBean>();
    private final Map<MultiKeyUntyped, EventBean> oldEventGroupReps = new LinkedHashMap<MultiKeyUntyped, EventBean>();
    private final Map<MultiKeyUntyped, EventBean[]> newGenerators = new HashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, EventBean[]> oldGenerators = new HashMap<MultiKeyUntyped, EventBean[]>();

    public ResultSetProcessorRowPerGroup(SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, List<ExprNode> groupKeyNodes, ExprNode optionalHavingNode, boolean isOutputLimiting, boolean isOutputLimitLastOnly) {
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.groupKeyNodes = groupKeyNodes;
        this.optionalHavingNode = optionalHavingNode;
        this.isOutputLimiting = isOutputLimiting;
        this.isOutputLimitLastOnly = isOutputLimitLastOnly;
        this.isSorting = orderByProcessor != null;
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public Pair<EventBean[], EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        EventBean[] selectNewEvents;
        int count;
        HashMap<MultiKeyUntyped, EventBean[]> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean[]>();
        MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newEvents, keysAndEvents, true);
        MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldEvents, keysAndEvents, false);
        EventBean[] selectOldEvents = this.generateOutputEventsJoin(keysAndEvents, this.optionalHavingNode, this.oldEventGroupReps, this.oldGenerators, false);
        if (!newEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                this.aggregationService.applyEnter(eventsPerStream.getArray(), newDataMultiKey[count]);
                ++count;
            }
        }
        if (!oldEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                this.aggregationService.applyLeave(eventsPerStream.getArray(), oldDataMultiKey[count]);
                ++count;
            }
        }
        if ((selectNewEvents = this.generateOutputEventsJoin(keysAndEvents, this.optionalHavingNode, this.newEventGroupReps, this.newGenerators, true)) != null || selectOldEvents != null) {
            return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public Pair<EventBean[], EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData) {
        EventBean[] selectNewEvents;
        int i;
        HashMap<MultiKeyUntyped, EventBean> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean>();
        MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
        MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
        EventBean[] selectOldEvents = this.generateOutputEventsView(keysAndEvents, this.optionalHavingNode, this.oldEventGroupReps, this.oldGenerators, false);
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i]);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i]);
            }
        }
        if ((selectNewEvents = this.generateOutputEventsView(keysAndEvents, this.optionalHavingNode, this.newEventGroupReps, this.newGenerators, true)) != null || selectOldEvents != null) {
            return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    private EventBean[] generateOutputEventsView(Map<MultiKeyUntyped, EventBean> keysAndEvents, ExprNode optionalHavingExpr, Map<MultiKeyUntyped, EventBean> groupReps, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData) {
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] events = new EventBean[keysAndEvents.size()];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[keysAndEvents.size()];
        EventBean[][] currentGenerators = null;
        if (this.isSorting) {
            currentGenerators = new EventBean[keysAndEvents.size()][];
        }
        int count = 0;
        for (Map.Entry<MultiKeyUntyped, EventBean> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentRow(entry.getKey());
            eventsPerStream[0] = entry.getValue();
            if (optionalHavingExpr != null && !(result = (Boolean)optionalHavingExpr.evaluate(eventsPerStream, isNewData)).booleanValue()) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData);
            keys[count] = entry.getKey();
            if (this.isSorting) {
                EventBean[] currentEventsPerStream = new EventBean[]{entry.getValue()};
                generators.put(keys[count], currentEventsPerStream);
                currentGenerators[count] = currentEventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.isSorting || this.isOutputLimiting && !this.isOutputLimitLastOnly) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
            }
            if (this.isSorting) {
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        return this.applyOutputLimitAndOrderBy(events, currentGenerators, keys, groupReps, generators, isNewData);
    }

    private EventBean[] generateOutputEventsJoin(Map<MultiKeyUntyped, EventBean[]> keysAndEvents, ExprNode optionalHavingExpr, Map<MultiKeyUntyped, EventBean> groupReps, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData) {
        EventBean[] events = new EventBean[keysAndEvents.size()];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[keysAndEvents.size()];
        EventBean[][] currentGenerators = null;
        if (this.isSorting) {
            currentGenerators = new EventBean[keysAndEvents.size()][];
        }
        int count = 0;
        for (Map.Entry<MultiKeyUntyped, EventBean[]> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentRow(entry.getKey());
            EventBean[] eventsPerStream = entry.getValue();
            if (optionalHavingExpr != null && !(result = (Boolean)optionalHavingExpr.evaluate(eventsPerStream, isNewData)).booleanValue()) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData);
            keys[count] = entry.getKey();
            if (this.isSorting) {
                generators.put(keys[count], eventsPerStream);
                currentGenerators[count] = eventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.isSorting || this.isOutputLimiting && !this.isOutputLimitLastOnly) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
            }
            if (this.isSorting) {
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        return this.applyOutputLimitAndOrderBy(events, currentGenerators, keys, groupReps, generators, isNewData);
    }

    private EventBean[] applyOutputLimitAndOrderBy(EventBean[] events, EventBean[][] currentGenerators, MultiKeyUntyped[] keys, Map<MultiKeyUntyped, EventBean> groupReps, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData) {
        if (this.isOutputLimiting && !this.isOutputLimitLastOnly) {
            int count = 0;
            for (MultiKeyUntyped key : keys) {
                groupReps.put(key, events[count++]);
            }
            events = groupReps.values().toArray(new EventBean[0]);
            if (this.isSorting) {
                currentGenerators = (EventBean[][])generators.values().toArray((T[])new EventBean[0][]);
                keys = groupReps.keySet().toArray(new MultiKeyUntyped[0]);
            }
        }
        if (this.isSorting) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData);
        }
        return events;
    }

    private MultiKeyUntyped[] generateGroupKeys(EventBean[] events, Map<MultiKeyUntyped, EventBean> eventPerKey, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
            if (eventPerKey.containsKey(keys[i])) continue;
            eventPerKey.put(keys[i], events[i]);
        }
        return keys;
    }

    private MultiKeyUntyped[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, Map<MultiKeyUntyped, EventBean[]> eventPerKey, boolean isNewData) {
        if (resultSet.isEmpty()) {
            return null;
        }
        MultiKeyUntyped[] keys = new MultiKeyUntyped[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            if (!eventPerKey.containsKey(keys[count])) {
                eventPerKey.put(keys[count], eventsPerStream.getArray());
            }
            ++count;
        }
        return keys;
    }

    protected MultiKeyUntyped generateGroupKey(EventBean[] eventsPerStream, boolean isNewData) {
        Object[] keys = new Object[this.groupKeyNodes.size()];
        int count = 0;
        for (ExprNode exprNode : this.groupKeyNodes) {
            keys[count] = exprNode.evaluate(eventsPerStream, isNewData);
            ++count;
        }
        return new MultiKeyUntyped(keys);
    }

    public ExprNode getOptionalHavingNode() {
        return this.optionalHavingNode;
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetRowPerGroupIterator(parent.iterator(), this, this.aggregationService);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<MultiKeyUntyped> orderKeys = new ArrayList<MultiKeyUntyped>();
        HashSet<MultiKeyUntyped> priorSeenGroups = new HashSet<MultiKeyUntyped>();
        Iterator<EventBean> it = parent.iterator();
        while (it.hasNext()) {
            EventBean candidate;
            eventsPerStream[0] = candidate = it.next();
            MultiKeyUntyped groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.setCurrentRow(groupKey);
            Boolean pass = true;
            if (this.optionalHavingNode != null) {
                pass = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, true);
            }
            if (!pass.booleanValue() || priorSeenGroups.contains(groupKey)) continue;
            priorSeenGroups.add(groupKey);
            if (this.selectExprProcessor == null) {
                outgoingEvents.add(candidate);
            } else {
                outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true));
            }
            MultiKeyUntyped orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[0]);
        MultiKeyUntyped[] orderKeysArr = orderKeys.toArray(new MultiKeyUntyped[0]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr);
        return new ArrayEventIterator(orderedEvents);
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        HashMap<MultiKeyUntyped, EventBean[]> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean[]>();
        this.generateGroupKeys(joinSet, keysAndEvents, true);
        EventBean[] selectNewEvents = this.generateOutputEventsJoin(keysAndEvents, this.optionalHavingNode, this.newEventGroupReps, this.newGenerators, true);
        return new ArrayEventIterator(selectNewEvents);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults();
    }
}

