/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.esper.collection.ArrayEventIterator;
import net.esper.collection.MultiKey;
import net.esper.collection.MultiKeyUntyped;
import net.esper.collection.Pair;
import net.esper.collection.TransformEventIterator;
import net.esper.collection.TransformEventMethod;
import net.esper.eql.core.OrderByProcessor;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.expression.ExprNode;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.Viewable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorSimple
implements ResultSetProcessor {
    private static final Log log = LogFactory.getLog(ResultSetProcessorSimple.class);
    private final SelectExprProcessor selectExprProcessor;
    private final boolean isOutputLimiting;
    private final boolean isOutputLimitLastOnly;
    private final OrderByProcessor orderByProcessor;
    private final ExprNode optionalHavingExpr;
    private final Set<MultiKey<EventBean>> emptyRowSet = new HashSet<MultiKey<EventBean>>();

    public ResultSetProcessorSimple(SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, ExprNode optionalHavingNode, boolean isOutputLimiting, boolean isOutputLimitLastOnly) {
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.optionalHavingExpr = optionalHavingNode;
        this.isOutputLimiting = isOutputLimiting;
        this.isOutputLimitLastOnly = isOutputLimitLastOnly;
    }

    @Override
    public EventType getResultEventType() {
        if (this.selectExprProcessor != null) {
            return this.selectExprProcessor.getResultEventType();
        }
        return null;
    }

    @Override
    public Pair<EventBean[], EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        EventBean[] selectNewEvents;
        EventBean[] selectOldEvents;
        if (this.optionalHavingExpr == null) {
            selectOldEvents = ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, oldEvents, this.isOutputLimiting, this.isOutputLimitLastOnly, false);
            selectNewEvents = ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, newEvents, this.isOutputLimiting, this.isOutputLimitLastOnly, true);
        } else {
            selectOldEvents = ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, oldEvents, this.optionalHavingExpr, this.isOutputLimiting, this.isOutputLimitLastOnly, false);
            selectNewEvents = ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, newEvents, this.optionalHavingExpr, this.isOutputLimiting, this.isOutputLimitLastOnly, true);
        }
        return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public Pair<EventBean[], EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData) {
        EventBean[] selectOldEvents = ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, oldData, this.isOutputLimiting, this.isOutputLimitLastOnly, false);
        EventBean[] selectNewEvents = ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, newData, this.isOutputLimiting, this.isOutputLimitLastOnly, true);
        return new Pair<EventBean[], EventBean[]>(selectNewEvents, selectOldEvents);
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, boolean isOutputLimiting, boolean isOutputLimitLastOnly, boolean isNewData) {
        if (isOutputLimiting) {
            events = ResultSetProcessorSimple.applyOutputLimit(events, isOutputLimitLastOnly);
        }
        if (events == null) {
            return null;
        }
        EventBean[] result = new EventBean[events.length];
        EventBean[][] eventGenerators = null;
        if (orderByProcessor != null) {
            eventGenerators = new EventBean[events.length][];
        }
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            result[i] = exprProcessor == null ? events[i] : exprProcessor.process(eventsPerStream, isNewData);
            if (orderByProcessor == null) continue;
            eventGenerators[i] = new EventBean[]{events[i]};
        }
        if (orderByProcessor != null) {
            return orderByProcessor.sort(result, eventGenerators, isNewData);
        }
        return result;
    }

    protected static EventBean[] applyOutputLimit(EventBean[] events, boolean isOutputLimitLastOnly) {
        if (isOutputLimitLastOnly && events != null && events.length > 0) {
            return new EventBean[]{events[events.length - 1]};
        }
        return events;
    }

    protected static Set<MultiKey<EventBean>> applyOutputLimit(Set<MultiKey<EventBean>> eventSet, boolean isOutputLimitLastOnly) {
        if (isOutputLimitLastOnly && eventSet != null && !eventSet.isEmpty()) {
            Object[] events = eventSet.toArray();
            LinkedHashSet<MultiKey<EventBean>> resultSet = new LinkedHashSet<MultiKey<EventBean>>();
            resultSet.add((MultiKey)events[events.length - 1]);
            return resultSet;
        }
        return eventSet;
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, boolean isOutputLimiting, boolean isOutputLimitLastOnly, boolean isNewData) {
        int length;
        if (isOutputLimiting) {
            events = ResultSetProcessorSimple.applyOutputLimit(events, isOutputLimitLastOnly);
        }
        if ((length = events.size()) == 0) {
            return null;
        }
        EventBean[] result = new EventBean[length];
        EventBean[][] eventGenerators = null;
        if (orderByProcessor != null) {
            eventGenerators = new EventBean[length][];
        }
        int count = 0;
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result[count] = exprProcessor.process(eventsPerStream, isNewData);
            if (orderByProcessor != null) {
                eventGenerators[count] = eventsPerStream;
            }
            ++count;
        }
        if (orderByProcessor != null) {
            return orderByProcessor.sort(result, eventGenerators, isNewData);
        }
        return result;
    }

    protected static EventBean[] getSelectEventsHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, ExprNode optionalHavingNode, boolean isOutputLimiting, boolean isOutputLimitLastOnly, boolean isNewData) {
        if (isOutputLimiting) {
            events = ResultSetProcessorSimple.applyOutputLimit(events, isOutputLimitLastOnly);
        }
        if (events == null) {
            return null;
        }
        LinkedList<EventBean> result = new LinkedList<EventBean>();
        ArrayList<EventBean[]> eventGenerators = null;
        if (orderByProcessor != null) {
            eventGenerators = new ArrayList<EventBean[]>();
        }
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            Boolean passesHaving = (Boolean)optionalHavingNode.evaluate(eventsPerStream, isNewData);
            if (!passesHaving.booleanValue()) continue;
            result.add(exprProcessor.process(eventsPerStream, isNewData));
            if (orderByProcessor == null) continue;
            eventGenerators.add(new EventBean[]{events[i]});
        }
        if (!result.isEmpty()) {
            if (orderByProcessor != null) {
                return orderByProcessor.sort(result.toArray(new EventBean[0]), (EventBean[][])eventGenerators.toArray((T[])new EventBean[0][]), isNewData);
            }
            return result.toArray(new EventBean[0]);
        }
        return null;
    }

    protected static EventBean[] getSelectEventsHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, ExprNode optionalHavingNode, boolean isOutputLimiting, boolean isOutputLimitLastOnly, boolean isNewData) {
        if (isOutputLimiting) {
            events = ResultSetProcessorSimple.applyOutputLimit(events, isOutputLimitLastOnly);
        }
        LinkedList<EventBean> result = new LinkedList<EventBean>();
        ArrayList<EventBean[]> eventGenerators = null;
        if (orderByProcessor != null) {
            eventGenerators = new ArrayList<EventBean[]>();
        }
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            Boolean passesHaving = (Boolean)optionalHavingNode.evaluate(eventsPerStream, isNewData);
            if (!passesHaving.booleanValue()) continue;
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData);
            result.add(resultEvent);
            if (orderByProcessor == null) continue;
            eventGenerators.add(eventsPerStream);
        }
        if (!result.isEmpty()) {
            if (orderByProcessor != null) {
                return orderByProcessor.sort(result.toArray(new EventBean[0]), (EventBean[][])eventGenerators.toArray((T[])new EventBean[0][]), isNewData);
            }
            return result.toArray(new EventBean[0]);
        }
        return null;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor != null) {
            EventBean[] eventsPerStream = new EventBean[1];
            ArrayList<EventBean> events = new ArrayList<EventBean>();
            ArrayList<MultiKeyUntyped> orderKeys = new ArrayList<MultiKeyUntyped>();
            Iterator<EventBean> it = parent.iterator();
            while (it.hasNext()) {
                eventsPerStream[0] = it.next();
                MultiKeyUntyped orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true);
                Pair<EventBean[], EventBean[]> pair = this.processViewResult(eventsPerStream, null);
                events.add(pair.getFirst()[0]);
                orderKeys.add(orderKey);
            }
            EventBean[] outgoingEvents = events.toArray(new EventBean[0]);
            MultiKeyUntyped[] orderKeysArr = orderKeys.toArray(new MultiKeyUntyped[0]);
            EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEvents, orderKeysArr);
            return new ArrayEventIterator(orderedEvents);
        }
        return new TransformEventIterator(parent.iterator(), new ResultSetSimpleTransform(this));
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        Pair<EventBean[], EventBean[]> result = this.processJoinResult(joinSet, this.emptyRowSet);
        return new ArrayEventIterator(result.getFirst());
    }

    @Override
    public void clear() {
    }

    public static class ResultSetSimpleTransform
    implements TransformEventMethod {
        private final ResultSetProcessorSimple resultSetProcessor;
        private final EventBean[] newData;

        public ResultSetSimpleTransform(ResultSetProcessorSimple resultSetProcessor) {
            this.resultSetProcessor = resultSetProcessor;
            this.newData = new EventBean[1];
        }

        public EventBean transform(EventBean event) {
            this.newData[0] = event;
            Pair<EventBean[], EventBean[]> pair = this.resultSetProcessor.processViewResult(this.newData, null);
            return pair.getFirst()[0];
        }
    }
}

