/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.esper.collection.MultiKeyUntyped;
import net.esper.eql.agg.AggregationService;
import net.esper.eql.core.ResultSetProcessorRowPerGroup;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetRowPerGroupIterator
implements Iterator<EventBean> {
    private final Iterator<EventBean> sourceIterator;
    private final ResultSetProcessorRowPerGroup resultSetProcessor;
    private final AggregationService aggregationService;
    private EventBean nextResult;
    private final EventBean[] eventsPerStream;
    private final Set<MultiKeyUntyped> priorSeenGroups;

    public ResultSetRowPerGroupIterator(Iterator<EventBean> sourceIterator, ResultSetProcessorRowPerGroup resultSetProcessor, AggregationService aggregationService) {
        this.sourceIterator = sourceIterator;
        this.resultSetProcessor = resultSetProcessor;
        this.aggregationService = aggregationService;
        this.eventsPerStream = new EventBean[1];
        this.priorSeenGroups = new HashSet<MultiKeyUntyped>();
    }

    @Override
    public boolean hasNext() {
        if (this.nextResult != null) {
            return true;
        }
        this.findNext();
        return this.nextResult != null;
    }

    @Override
    public EventBean next() {
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        this.findNext();
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNext() {
        while (this.sourceIterator.hasNext()) {
            EventBean candidate;
            this.eventsPerStream[0] = candidate = this.sourceIterator.next();
            MultiKeyUntyped groupKey = this.resultSetProcessor.generateGroupKey(this.eventsPerStream, true);
            this.aggregationService.setCurrentRow(groupKey);
            Boolean pass = true;
            if (this.resultSetProcessor.getOptionalHavingNode() != null) {
                pass = (Boolean)this.resultSetProcessor.getOptionalHavingNode().evaluate(this.eventsPerStream, true);
            }
            if (!pass.booleanValue() || this.priorSeenGroups.contains(groupKey)) continue;
            this.priorSeenGroups.add(groupKey);
            if (this.resultSetProcessor.getSelectExprProcessor() == null) {
                this.nextResult = candidate;
                break;
            }
            this.nextResult = this.resultSetProcessor.getSelectExprProcessor().process(this.eventsPerStream, true);
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

