/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.esper.eql.core.SelectExprJoinWildcardProcessor;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.InsertIntoDesc;
import net.esper.eql.spec.SelectExprElementCompiledSpec;
import net.esper.event.DecoratingEventBean;
import net.esper.event.EventAdapterException;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.event.WrapperEventType;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectExprEvalProcessor
implements SelectExprProcessor {
    private static final Log log = LogFactory.getLog(SelectExprEvalProcessor.class);
    private ExprNode[] expressionNodes;
    private String[] columnNames;
    private EventType resultEventType;
    private final EventAdapterService eventAdapterService;
    private final boolean isUsingWildcard;
    private boolean singleStreamWrapper;
    private boolean singleColumnCoercion;
    private SelectExprJoinWildcardProcessor joinWildcardProcessor;

    public SelectExprEvalProcessor(List<SelectExprElementCompiledSpec> selectionList, InsertIntoDesc insertIntoDesc, boolean isUsingWildcard, StreamTypeService typeService, EventAdapterService eventAdapterService) throws ExprValidationException {
        this.eventAdapterService = eventAdapterService;
        this.isUsingWildcard = isUsingWildcard;
        if (selectionList.size() == 0 && !isUsingWildcard) {
            throw new IllegalArgumentException("Empty selection list not supported");
        }
        for (SelectExprElementCompiledSpec entry : selectionList) {
            if (entry.getAssignedName() != null) continue;
            throw new IllegalArgumentException("Expected name for each expression has not been supplied");
        }
        if (insertIntoDesc != null) {
            SelectExprEvalProcessor.verifyInsertInto(insertIntoDesc, selectionList);
        }
        if (typeService.getStreamNames().length > 1 && isUsingWildcard) {
            this.joinWildcardProcessor = new SelectExprJoinWildcardProcessor(typeService.getStreamNames(), typeService.getEventTypes(), eventAdapterService, null);
        }
        EventType underlyingType = null;
        if (isUsingWildcard) {
            if (this.joinWildcardProcessor != null) {
                underlyingType = this.joinWildcardProcessor.getResultEventType();
            } else {
                underlyingType = typeService.getEventTypes()[0];
                if (underlyingType instanceof WrapperEventType) {
                    this.singleStreamWrapper = true;
                }
            }
        }
        this.init(selectionList, insertIntoDesc, underlyingType, eventAdapterService);
    }

    /*
     * Unable to fully structure code
     */
    private void init(List<SelectExprElementCompiledSpec> selectionList, InsertIntoDesc insertIntoDesc, EventType eventType, EventAdapterService eventAdapterService) throws ExprValidationException {
        this.expressionNodes = new ExprNode[selectionList.size()];
        for (i = 0; i < selectionList.size(); ++i) {
            this.expressionNodes[i] = selectionList.get(i).getSelectExpression();
        }
        if (insertIntoDesc != null && !insertIntoDesc.getColumnNames().isEmpty()) {
            this.columnNames = insertIntoDesc.getColumnNames().toArray(new String[0]);
        } else {
            this.columnNames = new String[selectionList.size()];
            for (i = 0; i < selectionList.size(); ++i) {
                this.columnNames[i] = selectionList.get(i).getAssignedName();
            }
        }
        selPropertyTypes = new HashMap<String, Class>();
        for (i = 0; i < this.expressionNodes.length; ++i) {
            expressionReturnType = this.expressionNodes[i].getType();
            selPropertyTypes.put(this.columnNames[i], expressionReturnType);
        }
        if (insertIntoDesc != null) {
            try {
                if (this.isUsingWildcard) {
                    this.resultEventType = eventAdapterService.addWrapperType(insertIntoDesc.getEventTypeAlias(), eventType, selPropertyTypes);
                }
                this.resultEventType = null;
                if (this.columnNames.length == 1 && insertIntoDesc.getColumnNames().size() == 0 && (existingType = eventAdapterService.getExistsTypeByAlias(insertIntoDesc.getEventTypeAlias())) != null) {
                    columnOneType = this.expressionNodes[0].getType();
                    if (existingType instanceof WrapperEventType && (wrapperType = (WrapperEventType)existingType).getUnderlyingEventType().getUnderlyingType() == columnOneType) {
                        this.singleColumnCoercion = true;
                        this.resultEventType = existingType;
                    }
                }
                if (this.resultEventType != null) ** GOTO lbl35
                this.resultEventType = eventAdapterService.addMapType(insertIntoDesc.getEventTypeAlias(), selPropertyTypes);
            }
            catch (EventAdapterException ex) {
                throw new ExprValidationException(ex.getMessage());
            }
        } else {
            this.resultEventType = this.isUsingWildcard != false ? eventAdapterService.createAnonymousWrapperType(eventType, selPropertyTypes) : eventAdapterService.createAnonymousMapType(selPropertyTypes);
        }
lbl35:
        // 4 sources

        if (SelectExprEvalProcessor.log.isDebugEnabled()) {
            SelectExprEvalProcessor.log.debug(".init resultEventType=" + this.resultEventType);
        }
    }

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (int i = 0; i < this.expressionNodes.length; ++i) {
            Object evalResult = this.expressionNodes[i].evaluate(eventsPerStream, isNewData);
            props.put(this.columnNames[i], evalResult);
        }
        if (this.isUsingWildcard) {
            DecoratingEventBean wrapper;
            if (this.singleStreamWrapper && (wrapper = (DecoratingEventBean)((Object)eventsPerStream[0])) != null) {
                Map<String, Object> map = wrapper.getDecoratingProperties();
                if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                    log.debug(".process additional properties=" + map);
                }
                props.putAll(map);
            }
            EventBean event = this.joinWildcardProcessor != null ? this.joinWildcardProcessor.process(eventsPerStream, isNewData) : eventsPerStream[0];
            return this.eventAdapterService.createWrapper(event, props, this.resultEventType);
        }
        if (this.singleColumnCoercion) {
            Object result = props.get(this.columnNames[0]);
            EventBean wrappedEvent = result instanceof Map ? this.eventAdapterService.createMapFromValues((Map)result, this.resultEventType) : this.eventAdapterService.adapterForBean(result);
            props.clear();
            return this.eventAdapterService.createWrapper(wrappedEvent, props, this.resultEventType);
        }
        return this.eventAdapterService.createMapFromValues(props, this.resultEventType);
    }

    @Override
    public EventType getResultEventType() {
        return this.resultEventType;
    }

    private static void verifyInsertInto(InsertIntoDesc insertIntoDesc, List<SelectExprElementCompiledSpec> selectionList) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (String element : insertIntoDesc.getColumnNames()) {
            if (names.contains(element)) {
                throw new ExprValidationException("Property name '" + element + "' appears more then once in insert-into clause");
            }
            names.add(element);
        }
        if (!insertIntoDesc.getColumnNames().isEmpty() && insertIntoDesc.getColumnNames().size() != selectionList.size()) {
            throw new ExprValidationException("Number of supplied values in the select clause does not match insert-into clause");
        }
    }
}

